% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidSVM.R
\name{clean.liquidSVM}
\alias{clean.liquidSVM}
\alias{clean}
\title{Force to release the internal memory of the C++ objects
associated to this model.}
\usage{
\method{clean}{liquidSVM}(model, warn = TRUE, ...)
}
\arguments{
\item{model}{the SVM model as returned by \code{\link{init.liquidSVM}}}

\item{warn}{if \code{TRUE} issue warning if the model already was deleted}

\item{...}{not used at the moment}
}
\description{
Usually this has not to be done by the user since
liquidSVM harnesses garbage collection offered by R.
}
\examples{
## Multiclass classification
modelIris <- svm(Species ~ ., iris)
y <- predict(modelIris, iris)

## Least Squares
modelTrees <- svm(Height ~ Girth + Volume, trees)
y <- predict(modelTrees, trees)
plot(trees$Height, y)
test(modelTrees, trees)

clean(modelTrees)
clean(modelIris)
# now predict(modelTrees, ...) would not be possible any more
}
\seealso{
\code{\link{init.liquidSVM}}
}
