% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_logic_linter.R
\name{vector_logic_linter}
\alias{vector_logic_linter}
\title{Enforce usage of scalar logical operators in conditional statements}
\usage{
vector_logic_linter()
}
\description{
Usage of \code{&} in conditional statements is error-prone and inefficient.
\code{condition} in \code{if (condition) expr} must always be length-1, in which
case \code{&&} is to be preferred. Ditto for \code{|} vs. \code{||}.
}
\details{
This linter covers inputs to \verb{if()} and \verb{while()} conditions and to
\code{\link[testthat:logical-expectations]{testthat::expect_true()}} and \code{\link[testthat:logical-expectations]{testthat::expect_false()}}.
}
\seealso{
\link{linters} for a complete list of linters available in lintr. \cr
\url{https://style.tidyverse.org/syntax.html#if-statements}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=default_linters]{default}, \link[=efficiency_linters]{efficiency}
}
