% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T_and_F_symbol_linter.R,
%   R/assignment_linter.R, R/closed_curly_linter.R, R/commas_linter.R,
%   R/comment_linters.R, R/cyclocomp_linter.R, R/object_name_linters.R,
%   R/deprecated.R, R/equals_na_lintr.R, R/extraction_operator_linter.R,
%   R/function_left_parentheses.R, R/implicit_integer_linter.R,
%   R/infix_spaces_linter.R, R/line_length_linter.R,
%   R/no_tab_linter.R, R/object_usage_linter.R, R/open_curly_linter.R,
%   R/paren_brace_linter.R, R/path_linters.R, R/pipe_continuation_linter.R,
%   R/semicolon_terminator_linter.R, R/seq_linter.R, R/single_quotes_linter.R,
%   R/spaces_inside_linter.R, R/spaces_left_parentheses_linter.R,
%   R/trailing_blank_lines_linter.R, R/trailing_whitespace_linter.R,
%   R/undesirable_function_linter.R, R/undesirable_operator_linter.R,
%   R/unneeded_concatenation_linter.R, R/zzz.R
\name{T_and_F_symbol_linter}
\alias{T_and_F_symbol_linter}
\alias{assignment_linter}
\alias{closed_curly_linter}
\alias{commas_linter}
\alias{commented_code_linter}
\alias{todo_comment_linter}
\alias{cyclocomp_linter}
\alias{object_name_linter}
\alias{object_length_linter}
\alias{camel_case_linter}
\alias{equals_na_linter}
\alias{extraction_operator_linter}
\alias{function_left_parentheses_linter}
\alias{implicit_integer_linter}
\alias{infix_spaces_linter}
\alias{line_length_linter}
\alias{no_tab_linter}
\alias{object_usage_linter}
\alias{open_curly_linter}
\alias{paren_brace_linter}
\alias{absolute_path_linter}
\alias{nonportable_path_linter}
\alias{pipe_continuation_linter}
\alias{semicolon_terminator_linter}
\alias{seq_linter}
\alias{single_quotes_linter}
\alias{spaces_inside_linter}
\alias{spaces_left_parentheses_linter}
\alias{trailing_blank_lines_linter}
\alias{trailing_whitespace_linter}
\alias{undesirable_function_linter}
\alias{undesirable_operator_linter}
\alias{unneeded_concatenation_linter}
\alias{linters}
\title{linters}
\usage{
T_and_F_symbol_linter(source_file)

assignment_linter(source_file)

closed_curly_linter(allow_single_line = FALSE)

commas_linter(source_file)

commented_code_linter(source_file)

todo_comment_linter(todo = c("todo", "fixme"))

cyclocomp_linter(complexity_limit = 25)

object_name_linter(styles = "snake_case")

object_length_linter(length = 30L)

camel_case_linter(source_file)

equals_na_linter(source_file)

extraction_operator_linter(source_file)

function_left_parentheses_linter(source_file)

implicit_integer_linter(source_file)

infix_spaces_linter(source_file)

line_length_linter(length)

no_tab_linter(source_file)

object_usage_linter(source_file)

open_curly_linter(allow_single_line = FALSE)

paren_brace_linter(source_file)

absolute_path_linter(lax = TRUE)

nonportable_path_linter(lax = TRUE)

pipe_continuation_linter(source_file)

semicolon_terminator_linter(semicolon = c("compound", "trailing"))

seq_linter(source_file)

single_quotes_linter(source_file)

spaces_inside_linter(source_file)

spaces_left_parentheses_linter(source_file)

trailing_blank_lines_linter(source_file)

trailing_whitespace_linter(source_file)

undesirable_function_linter(fun = default_undesirable_functions)

undesirable_operator_linter(op = default_undesirable_operators)

unneeded_concatenation_linter(source_file)
}
\arguments{
\item{source_file}{returned by \code{\link{get_source_expressions}}}

\item{allow_single_line}{if true allow a open and closed curly pair on the
same line.}

\item{todo}{Vector of strings that identify TODO comments.}

\item{complexity_limit}{expressions with a cyclomatic complexity higher than
this are linted, defaults to 25. See \code{\link[cyclocomp]{cyclocomp}}.}

\item{styles}{A subset of
\Sexpr[stage=render, results=rd]{lintr:::regexes_rd}. A name should
match at least one of these styles.}

\item{length}{the length cutoff to use for the given linter.}

\item{lax}{Less stringent linting, leading to fewer false positives.}

\item{semicolon}{A character vector defining which semicolons to report:\describe{
  \item{compound}{Semicolons that separate two statements on the same line.}
  \item{trailing}{Semicolons following the last statement on the line.}
}}

\item{fun}{Named character vector, where the names are the names of the undesirable functions,
and the values are the text for the alternative function to use (or \code{NA}).}

\item{op}{Named character vector, where the names are the names of the undesirable operators,
and the values are the text for the alternative operator to use (or \code{NA}).}
}
\description{
Available linters
}
\section{Functions}{
\itemize{
\item \code{T_and_F_symbol_linter}: Avoid the symbols \code{T} and \code{F} (for \code{TRUE} and \code{FALSE}).

\item \code{assignment_linter}: checks that '<-' is always used for assignment

\item \code{closed_curly_linter}: check that closed curly braces should always be on their
own line unless they follow an else.

\item \code{commas_linter}: check that all commas are followed by spaces, but do not
have spaces before them.

\item \code{commented_code_linter}: Check that there is no commented code outside roxygen
blocks

\item \code{todo_comment_linter}: Check that the source contains no TODO comments (case-insensitive).

\item \code{cyclocomp_linter}: Check for overly complicated expressions. See
\code{\link[cyclocomp]{cyclocomp}}.

\item \code{object_name_linter}: Check that object names conform to a naming style.

\item \code{object_length_linter}: check that object names are not too long.

\item \code{camel_case_linter}: check that objects are not in camelCase.

\item \code{equals_na_linter}: that checks for x == NA

\item \code{extraction_operator_linter}: Check that the `[[` operator is used when extracting a single element from
an object, not `[` (subsetting) nor `$` (interactive use).

\item \code{function_left_parentheses_linter}: check that all left parentheses in a function call
do not have spaces before them.

\item \code{implicit_integer_linter}: Check that integers are explicitly typed using the form \code{1L} instead of
\code{1}.

\item \code{infix_spaces_linter}: check that all infix operators have spaces around them.

\item \code{line_length_linter}: check the line length of both comments and code is less
than length.

\item \code{no_tab_linter}: check that only spaces are used for indentation, not tabs.

\item \code{object_usage_linter}: checks that closures have the proper usage using
\code{\link[codetools]{checkUsage}}.  Note this runs
\code{\link[base]{eval}} on the code, so do not use with untrusted code.

\item \code{open_curly_linter}: check that opening curly braces are never on their own
line and are always followed by a newline.

\item \code{paren_brace_linter}: check that there is a space between right
parenthesis and an opening curly brace.

\item \code{absolute_path_linter}: Check that no absolute paths are used (e.g. "/var", "C:\\System", "~/docs").

\item \code{nonportable_path_linter}: Check that file.path() is used to construct safe and portable paths.

\item \code{pipe_continuation_linter}: Check that each step in a pipeline is on a new line, or
the entire pipe fits on one line.

\item \code{semicolon_terminator_linter}: Check that no semicolons terminate statements.

\item \code{seq_linter}: check for \code{1:length(...)}, \code{1:nrow(...)},
\code{1:ncol(...)}, \code{1:NROW(...)} and \code{1:NCOL(...)}
expressions. These often cause bugs when the right hand side is zero.
It is safer to use \code{\link[base]{seq_len}} or
\code{\link[base]{seq_along}} instead.

\item \code{single_quotes_linter}: checks that only single quotes are used to delimit
string constants.

\item \code{spaces_inside_linter}: check that parentheses and square brackets do not have
spaces directly inside them.

\item \code{spaces_left_parentheses_linter}: check that all left parentheses have a space before them
unless they are in a function call.

\item \code{trailing_blank_lines_linter}: check there are no trailing blank lines.

\item \code{trailing_whitespace_linter}: check there are no trailing whitespace characters.

\item \code{undesirable_function_linter}: Report the use of undesirable functions, e.g. \code{return}, \code{options},
or \code{sapply} and suggest an alternative.

\item \code{undesirable_operator_linter}: Report the use of undesirable operators, e.g. \code{`:::`} or \code{`<<-`}
and suggest an alternative.

\item \code{unneeded_concatenation_linter}: Check that the \code{c} function is not used without arguments nor with a
single constant.
}}

