% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqDGP.R
\name{predict.lineqDGP}
\alias{predict.lineqDGP}
\title{Prediction Method for the \code{"lineqDGP"} S3 Class}
\usage{
\method{predict}{lineqDGP}(object, xtest, ...)
}
\arguments{
\item{object}{an object with class \code{"lineqDGP"}.}

\item{xtest}{a vector (or matrix) with the test input design.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object with the predictions of \code{"lineqDGP"} models.
\item{lb}{The lower bound vector of the inequalities constraints.}
\item{ub}{The upper bound vector of the inequalities constraints.}
\item{Phi.test}{A matrix corresponding to the hat basis functions evaluated at \code{xtest}.
The basis functions are indexed by rows.}
\item{mu}{The unconstrained GP mean predictor.}
\item{xi.map}{The GP maximum a posteriori (MAP) predictor given the inequality constraints.}
\item{Sigma.xi}{The unconstrained GP prediction conditional covariance matrix.}
}
\description{
Prediction method for the \code{"lineqDGP"} S3 class.
}
\details{
The posterior sample-path of the finite-dimensional GP with inequality constraints is computed
according to (Maatouk and Bay, 2017).
}
\examples{
# creating the model
sigfun <- function(x) return(1/(1+exp(-7*(x-0.5))))
x <- seq(0, 1, length = 5)
y <- sigfun(x)
model <- create(class = "lineqDGP", x, y, constrType = "monotonicity")

# updating and expanding the model
model$localParam$m <- 30
model$kernParam$par <- c(1, 0.2)
model <- augment(model)

# predictions from the model
xtest <- seq(0, 1, length = 100)
ytest <- sigfun(xtest)
pred <- predict(model, xtest)
plot(xtest, ytest, type = "l", lty = 2, main = "Kriging predictions")
lines(xtest, pred$Phi.test \%*\% pred$mu, type = "l", col = "blue")
lines(xtest, pred$Phi.test \%*\% pred$xi.map, type = "l", col = "red")
legend("right", c("ytest", "mean", "mode"), lty = c(2,1,1),
       col = c("black","blue","red"))

}
\references{
Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5):557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\seealso{
\code{\link{create.lineqDGP}}, \code{\link{augment.lineqDGP}}, \code{\link{simulate.lineqDGP}}
}
\author{
A. F. Lopez-Lopera.
}
