% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/event_creation.R
\name{seq_events}
\alias{seq_events}
\title{Generate Sequential Events}
\usage{
seq_events(coverage, length.out = NULL, by = NULL, adaptive = FALSE)
}
\arguments{
\item{coverage}{An event table specifying the non-overlapping intervals to which the event sequences will be fitted. Gaps in coverage do not count towards event length. Points in the coverage are currently ignored.}

\item{length.out}{The number of events in each sequence. Event lengths are chosen such that they evenly divide the \code{coverage}.}

\item{by}{The length of the events in each sequence. Ignored if \code{length.out} is defined. When the length does not evenly divide the \code{coverage}, a shorter event is appended to the end of the sequence.}

\item{adaptive}{If \code{TRUE}, events are adjusted locally so that a whole number of events fit within each coverage interval, preserving breaks and gaps.}
}
\value{
An endpoint-only event table with an additional group field if the length of \code{length.out} or \code{by} is \code{>} 1.
}
\description{
Generates groups of regularly sequenced events fitted to the specified intervals. Intended for use as bins with \code{\link{sample_events}}.
}
\examples{
e <- events(c(0, 20, 40), c(10, 30, 45))
no.gaps <- event_range(e)
has.gaps <- event_coverage(e)
seq_events(no.gaps, by = 10)                           # unequal length (last is shorter)
seq_events(no.gaps, by = 10, adaptive = TRUE)          # equal length (11.25)
seq_events(no.gaps, length.out = 4)                    # equal length (11.25)
seq_events(has.gaps, length.out = 4, adaptive = FALSE) # equal coverage (11.25), straddling gaps
seq_events(has.gaps, length.out = 4, adaptive = TRUE)  # unequal coverage, fitted to gaps
seq_events(no.gaps, length.out = c(2, 4))              # "group" column added
}
\seealso{
\code{\link{event_range}}, \code{\link{event_coverage}}, and \code{\link{fill_event_gaps}} for building a \code{coverage} from an existing event table.
}

