% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sreserve.R
\name{sreserve}
\alias{sreserve}
\title{Reserve with Dynamic Rate}
\usage{
sreserve(t, TT, Lambda, R, mu, r, n)
}
\arguments{
\item{t}{Initial timepoint}

\item{TT}{End timepoint}

\item{Lambda}{Intensity matrix}

\item{R}{Reward matrix}

\item{mu}{Equivalence premium}

\item{r}{A function of time that returns the interest rate}

\item{n}{Number of steps for the Runge-Kutta algorithm}
}
\value{
A matrix representing statewise reserves
}
\description{
This function calculates the reserve matrix using a dynamic interest rate function.
It extends the functionality of the \code{reserve} function by allowing the rate to vary over time.
}
\examples{
Lambda <- function(x) matrix(c(-0.1, 0.1, 0, -0.1), 2, 2)
R <- function(x, mu) matrix(c(0, 0, 0, mu), 2, 2)
rentefun <- function(x) { 0.01 + 0.001 * x }  # Dynamic interest rate
sreserve(0, 80, Lambda, R, 200000, rentefun, 1000)
}
