% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SitesReport.R
\name{SitesReport}
\alias{SitesReport}
\title{Create report for sites with most unseen species}
\usage{
SitesReport(
  centers,
  ebird_key,
  species_seen,
  center_names = NULL,
  report_filename = "Goals-Report",
  report_dir = getwd(),
  report_format = c("html", "pdf"),
  max_sites = 5,
  dist = 50,
  back = 4,
  hotspot = TRUE,
  include_provisional = FALSE,
  max_tries = 5,
  timeout_sec = 30,
  messages = c("minimal", "none", "verbose"),
  drop_patterns = c("sp.", "/", "Domestic type", "hybrid"),
  include_maps = TRUE
)
}
\arguments{
\item{centers}{Numeric vector or matrix of latitude and longitude
coordinates; vector should be of length 2, e.g. 
\code{c(latitude, longitude)}, while matrix should have two columns (first 
column is latitude, second column is longitude).}

\item{ebird_key}{Character vector with eBird API key.}

\item{species_seen}{Character vector of species that have already been seen.}

\item{center_names}{Character vector of names to use for each pair of 
latitude and longitude coordinates in \code{centers}.}

\item{report_filename}{Name of output file without file extension (see 
\code{report_format}); e.g. if \code{report_filename} is "sites-2021" and 
\code{report_format} is "html", the report will be saved to sites-2021.html.}

\item{report_dir}{Destination folder for the output file; if \code{NULL}, 
report will be saved to working directory.}

\item{report_format}{File format for report; takes one of two values: "html" 
or "pdf".}

\item{max_sites}{Maximum number of sites to return for each pair of
coordinates defined in \code{centers}; maximum is 12.}

\item{dist}{Numeric radius in kilometers of distance from each geographic 
center point defined by coordinates in \code{centers} from which to return 
recent observations.}

\item{back}{Number of days back to search for observations.}

\item{hotspot}{Logical indicating whether or not to restrict results to
hotspot locations.}

\item{include_provisional}{Logical indicating whether not to include
observations which have not yet been reviewed.}

\item{max_tries}{Maximum number of query attempts to try (only for
expert use).}

\item{timeout_sec}{Integer time to allow before query is aborted (only for
expert use).}

\item{messages}{Character indicating the degree to which messages are 
printed during the report assembly process. Options are "minimal", "none", 
or "verbose".}

\item{drop_patterns}{Character vector of patterns in species' names to
exclude certain species from consideration, such as domesticated species,
hybrids, and observations not identified to species level (e.g.
"Toxostoma sp.").}

\item{include_maps}{Logical vector indicating whether or not to draw maps 
of identified sites; should be length 1 or the number of centers (i.e. same
length as \code{centers} if \code{centers} is a vector, same number of rows
as \code{centers} if \code{centers} is a matrix).}
}
\value{
Silently returns a list with two named elements:
\describe{
  \item{results_list}{A list where each element is a list of the results of 
  queries for a center. Each element is a list with two named elements:}
    \describe{
      \item{center_info}{A list with latitude (\code{lat}), longitude 
      (\code{longitude}), and name \code{name} of the geographic center.}
      \item{results}{A tibble of observations from the top sites (with a 
      maximum number of sites defined by \code{max_sites}).}
    }
  \item{report_details}{A list containing the settings used to build this 
  report, such as days back and distances.}
}
}
\description{
Create report for sites with most unseen species
}
\details{
The function uses the eBird API (see \url{https://documenter.getpostman.com/view/664302/S1ENwy59/})
to build the report. Queries to the eBird API require a user key; you can 
request an eBird API key by logging into your eBird account and navigating 
to \url{https://ebird.org/api/keygen/}. See examples and vignette for using 
your eBird API key.
}
\examples{
\dontrun{
  # Read in data downloaded from eBird
  list_file <- system.file("extdata", "example-list.csv", package = "lifeR")
  user_list <- read.csv(file = list_file)
  # Only common names are required
  my_species <- user_list$Common.Name
  # Read in eBird API key from a text file
  key <- scan(file = "ebird-key.txt", what = "character")

  # A single center requires vector of coordinates
  locs <- c(45, -109)
  SitesReport(centers = locs, ebird_key = key, 
  species_seen = my_species)
  
  # For multiple centers, pass a matrix to centers argument
  loc_mat <- matrix(data = c(33, -109, 39, -119.1), nrow = 2, byrow = TRUE)
  loc_names <- c("Brushy Mountain", "Yerington")
  SitesReport(centers = loc_mat, ebird_key = key, 
  species_seen = my_species, center_names = loc_names)
}
}
