% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{points2DSM}
\alias{points2DSM}
\title{Digital Surface Model}
\usage{
points2DSM(.las, res = 1, xmin, xmax, ymin, ymax)
}
\arguments{
\item{.las}{\code{\link[lidR]{LAS}} object or XYZ matrix/data.frame}

\item{res}{numeric. raster resolution}

\item{xmin}{numeric. lower left corner easting coordinate for output raster.}

\item{xmax}{numeric. upper right corner easting coordinate for output raster.}

\item{ymin}{numeric. lower left corner northing coordinate for output raster.}

\item{ymax}{numeric. upper right corner northing coordinate for output raster.}
}
\value{
A raster object.
}
\description{
Creates a Digital Surface Model from LAS object. Raster extent is specified
by the coordinates of lower left and upper right corners. Default extent covers
 the full range of points, and aligns on multiple values of the resolution.
 Cell value is the maximum height of points contained in the cell.
}
\examples{
# load LAS file
LASfile <- system.file("extdata", "las_chablais3.laz", package="lidaRtRee")
las_chablais3 <- lidR::readLAS(LASfile)
# set projection
lidR::projection(las_chablais3) <- 2154

# create a digital surface model with first-return points, resolution 0.5 m
dsm <- points2DSM(lidR::filter_first(las_chablais3), res = 0.5)

# display raster
raster::plot(dsm, asp = 1)
}
\seealso{
\code{\link{points2DTM}} for Digital Terrain Model computation.
}
