% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{treeExtraction}
\alias{treeExtraction}
\title{Tree extraction}
\usage{
treeExtraction(r.dem.nl, r.maxi, r.dem.w, r.mask = NULL)
}
\arguments{
\item{r.dem.nl}{raster object. raster of canopy height model, preferably filtered to avoid effect of holes on volume and surface computation}

\item{r.maxi}{raster object. raster positive values at local maxima}

\item{r.dem.w}{raster object. segmented raster}

\item{r.mask}{raster object. only segments which maxima are inside the mask are extracted}
}
\value{
A spatial data.frame with tree id, local maximum stats (height, dominance radius), segment stats (surface and volume).
}
\description{
creates a dataframe with segment id, height and coordinates of maxima, surface and volume, computed from three images: initial, local maxima and segmented, obtained with \code{\link{treeSegmentation}}
}
\examples{
data(chmchablais3)

# tree segmentation
segments <- treeSegmentation(chmchablais3)

# tree extraction
trees <- treeExtraction(segments$filled.dem, segments$local.maxima,
                        segments$segments.id)
trees

# plot initial image
raster::plot(chmchablais3)

# add treetop positions
sp::plot(trees, cex=trees$h/20, add=TRUE, pch=1)
\donttest{
# add segment contours (vectorization is slow)
contours <- raster::rasterToPolygons(segments$segments.id, dissolve=TRUE)
sp::plot(contours, add=TRUE, border="white")}
 
}
\seealso{
\code{\link{treeSegmentation}}
}
