% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{plotTreeInventory}
\alias{plotTreeInventory}
\title{Displays a map of tree inventory data}
\usage{
plotTreeInventory(xy, height = NULL, diam = NULL, species = NULL, ...)
}
\arguments{
\item{xy}{data.frame. contains two columns with the X, Y  coordinates of tree centers}

\item{height}{vector.  tree heights in meters}

\item{diam}{vector. tree diameters in centimeters}

\item{species}{vector. species abbreviation as in \code{\link{speciesColor}} for display with corresponding color}

\item{...}{Arguments to be passed to methods, as in \code{\link[graphics]{plot}}}
}
\value{
no return
}
\description{
displays tree inventory data
}
\examples{
# load tree inventory data from plot Chablais 3
data("treeinventorychablais3")

# display tree inventory
plotTreeInventory(treeinventorychablais3[,c("x","y")],
diam = treeinventorychablais3$d, col = "red",
pch = treeinventorychablais3$e,
xlab = "X", ylab = "Y")

# display tree inventory with CHM background
data("chmchablais3")
raster::plot(chmchablais3, col=gray(seq(0,1,1/255)))
plotTreeInventory(treeinventorychablais3[,c("x","y")],
height = treeinventorychablais3$h,
species = treeinventorychablais3$s,
add = TRUE)

}
\seealso{
\code{\link{speciesColor}} for a table of species and associated colors
}
