% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_spatial.r
\docType{methods}
\name{area}
\alias{area}
\alias{area,LAS-method}
\alias{area,LAScatalog-method}
\alias{area,numeric-method}
\title{Surface covered by a \code{LAS} object or by a \code{LAScatalog}.}
\usage{
area(x, ...)

\S4method{area}{LAS}(x, ...)

\S4method{area}{LAScatalog}(x, ...)

\S4method{area}{numeric}(x, y, ...)
}
\arguments{
\item{x}{An object of the class \code{LAS} or \code{LAScatalog} or numeric}

\item{...}{unused}

\item{y}{If x is numeric, then provide also y.}
}
\value{
numeric. The area of the object computed in the same units as the coordinate reference system
}
\description{
The area is computed with the convex hull for \code{LAS} objects or x,y coordinates. If
the data is not convex, the resulting area is only an approximation. The area is computed
as the sum of the extents of each file for a \code{LAScatalog}.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)
area(las)
}
\seealso{
\code{\link[raster:area]{raster::area} }
}
