/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_OptimalDesign_new()
{
	so_OptimalDesign *obj = so_OptimalDesign_new();
	if (!obj) {
		error("Failed to create so_OptimalDesign object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_OptimalDesign_copy(SEXP self)
{
	so_OptimalDesign *obj = so_OptimalDesign_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_OptimalDesign object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_OptimalDesign_free(SEXP self)
{
	so_OptimalDesign_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_OptimalDesign_ref(SEXP self)
{
	so_OptimalDesign_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_OptimalDesign_unref(SEXP self)
{
	so_OptimalDesign_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_OptimalDesign_get_OptimalDesignBlock(SEXP self, SEXP index)
{
	so_OptimalDesignBlock *child = so_OptimalDesign_get_OptimalDesignBlock(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_OptimalDesign_get_number_of_OptimalDesignBlock(SEXP self)
{
	int number = so_OptimalDesign_get_number_of_OptimalDesignBlock(R_ExternalPtrAddr(self));
	SEXP r_int = PROTECT(NEW_INTEGER(1));
	INTEGER(r_int)[0] = number;
	UNPROTECT(1);
	return r_int;
}
SEXP r_so_OptimalDesign_add_OptimalDesignBlock(SEXP self, SEXP child)
{
	int fail = so_OptimalDesign_add_OptimalDesignBlock(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	if (fail) {
		error("Failed to add OptimalDesignBlock to OptimalDesign");
	}
	return(R_NilValue);
}
SEXP r_so_OptimalDesign_remove_OptimalDesignBlock(SEXP self, SEXP index)
{
	int fail = so_OptimalDesign_remove_OptimalDesignBlock(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	if (fail) {
		error("Failed to remove OptimalDesignBlock from OptimalDesign");
	}
	return(R_NilValue);
}
SEXP r_so_OptimalDesign_create_OptimalDesignBlock(SEXP self)
{
	so_OptimalDesignBlock *child = so_OptimalDesign_create_OptimalDesignBlock(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_OptimalDesign_get_type(SEXP self)
{
	char *value = so_OptimalDesign_get_type(R_ExternalPtrAddr(self));

	SEXP result;

	if (value) {
		result = PROTECT(NEW_STRING(1));
		SET_STRING_ELT(result, 0, mkChar(value));

		UNPROTECT(1);
	} else {
		result = R_NilValue;
	}
	return result;
}

SEXP r_so_OptimalDesign_set_type(SEXP self, SEXP string)
{
	char *c_string = (char *) CHAR(STRING_ELT(string, 0));
	int fail = so_OptimalDesign_set_type(R_ExternalPtrAddr(self), c_string);
	if (fail) {
		error("so_OptimalDesign_set_type failed");
	}

	return R_NilValue;
}

