/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/Bayesian_PPE.h>
#include <so/private/Bayesian_PPE.h>

so_Bayesian_PPE *so_Bayesian_PPE_new()
{
	so_Bayesian_PPE *object = calloc(sizeof(so_Bayesian_PPE), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_Bayesian_PPE *so_Bayesian_PPE_copy(so_Bayesian_PPE *self)
{
	so_Bayesian_PPE *dest = so_Bayesian_PPE_new();
	if (dest) {
		if (self->StandardDeviationPosterior) {
			dest->StandardDeviationPosterior = so_Table_copy(self->StandardDeviationPosterior);
			if (!dest->StandardDeviationPosterior) {
				so_Bayesian_PPE_free(dest);
				return NULL;
			}
		}
		if (self->PercentilesCI) {
			dest->PercentilesCI = so_Table_copy(self->PercentilesCI);
			if (!dest->PercentilesCI) {
				so_Bayesian_PPE_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_Bayesian_PPE_free(so_Bayesian_PPE *self)
{
	if (self) {
		so_Table_unref(self->StandardDeviationPosterior);
		so_Table_unref(self->PercentilesCI);
		free(self);
	}
}

void so_Bayesian_PPE_ref(so_Bayesian_PPE *self)
{
	self->reference_count++;
}

void so_Bayesian_PPE_unref(so_Bayesian_PPE *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_Bayesian_PPE_free(self);
		}
	}
}

so_Table *so_Bayesian_PPE_get_StandardDeviationPosterior(so_Bayesian_PPE *self)
{
	return self->StandardDeviationPosterior;
}

so_Table *so_Bayesian_PPE_get_PercentilesCI(so_Bayesian_PPE *self)
{
	return self->PercentilesCI;
}

void so_Bayesian_PPE_set_StandardDeviationPosterior(so_Bayesian_PPE *self, so_Table *value)
{
	so_Table_unref(self->StandardDeviationPosterior);
	self->StandardDeviationPosterior = value;
}

void so_Bayesian_PPE_set_PercentilesCI(so_Bayesian_PPE *self, so_Table *value)
{
	so_Table_unref(self->PercentilesCI);
	self->PercentilesCI = value;
}

so_Table *so_Bayesian_PPE_create_StandardDeviationPosterior(so_Bayesian_PPE *self)
{
	so_Table *obj = so_Table_new("StandardDeviationPosterior");
	if (obj) {
		self->StandardDeviationPosterior = obj;
	}
	return obj;
}

so_Table *so_Bayesian_PPE_create_PercentilesCI(so_Bayesian_PPE *self)
{
	so_Table *obj = so_Table_new("PercentilesCI");
	if (obj) {
		self->PercentilesCI = obj;
	}
	return obj;
}

int so_Bayesian_PPE_xml(so_Bayesian_PPE *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->StandardDeviationPosterior || self->PercentilesCI) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "Bayesian");
		if (rc < 0) return 1;
		if (self->StandardDeviationPosterior) {
			rc = so_Table_xml(self->StandardDeviationPosterior, writer, "StandardDeviationPosterior");
			if (rc != 0) return rc;
		}
		if (self->PercentilesCI) {
			rc = so_Table_xml(self->PercentilesCI, writer, "PercentilesCI");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_Bayesian_PPE_start_element(so_Bayesian_PPE *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_StandardDeviationPosterior) {
		int fail = so_Table_start_element(self->StandardDeviationPosterior, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PercentilesCI) {
		int fail = so_Table_start_element(self->PercentilesCI, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "StandardDeviationPosterior") == 0) {
		so_Table *StandardDeviationPosterior = so_Bayesian_PPE_create_StandardDeviationPosterior(self);
		if (!StandardDeviationPosterior) {
			return 1;
		}
		self->in_StandardDeviationPosterior = 1;
	} else if (strcmp(localname, "PercentilesCI") == 0) {
		so_Table *PercentilesCI = so_Bayesian_PPE_create_PercentilesCI(self);
		if (!PercentilesCI) {
			return 1;
		}
		self->in_PercentilesCI = 1;
	}
	return 0;
}

void so_Bayesian_PPE_end_element(so_Bayesian_PPE *self, const char *localname)
{
	if (strcmp(localname, "StandardDeviationPosterior") == 0 && self->in_StandardDeviationPosterior) {
		self->in_StandardDeviationPosterior = 0;
	} else if (strcmp(localname, "PercentilesCI") == 0 && self->in_PercentilesCI) {
		self->in_PercentilesCI = 0;
	} else if (self->in_StandardDeviationPosterior) {
		so_Table_end_element(self->StandardDeviationPosterior, localname);
	} else if (self->in_PercentilesCI) {
		so_Table_end_element(self->PercentilesCI, localname);
	}
}

int so_Bayesian_PPE_characters(so_Bayesian_PPE *self, const char *ch, int len)
{
	if (self->in_StandardDeviationPosterior) {
		int fail = so_Table_characters(self->StandardDeviationPosterior, ch, len);
		if (fail) return 1;
	} else if (self->in_PercentilesCI) {
		int fail = so_Table_characters(self->PercentilesCI, ch, len);
		if (fail) return 1;
	}
	return 0;
}
