/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_PRIVATE_SOBLOCK_H
#define _SO_PRIVATE_SOBLOCK_H

#include <libxml/xmlwriter.h>

#include <so/private/ToolSettings.h>
#include <so/private/RawResults.h>
#include <so/private/TaskInformation.h>
#include <so/private/Estimation.h>
#include <so/private/Simulation.h>
#include <so/private/ModelDiagnostic.h>
#include <so/private/OptimalDesign.h>

struct so_SOBlock {
	char *blkId;
	so_ToolSettings *ToolSettings;
	so_RawResults *RawResults;
	so_TaskInformation *TaskInformation;
	so_Estimation *Estimation;
	so_Simulation *Simulation;
	so_ModelDiagnostic *ModelDiagnostic;
	so_OptimalDesign *OptimalDesign;
	int in_ToolSettings;
	int in_RawResults;
	int in_TaskInformation;
	int in_Estimation;
	int in_Simulation;
	int in_ModelDiagnostic;
	int in_OptimalDesign;
	int reference_count;
};

int so_SOBlock_start_element(so_SOBlock *self, const char *localname, int nb_attributes, const char **attributes);
void so_SOBlock_end_element(so_SOBlock *self, const char *localname);
int so_SOBlock_characters(so_SOBlock *self, const char *ch, int len);
int so_SOBlock_xml(so_SOBlock *self, xmlTextWriterPtr writer);
int so_SOBlock_init_attributes(so_SOBlock *self, int nb_attributes, const char **attributes);

#endif
