% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_committee.R
\name{search_committee}
\alias{search_committee}
\alias{legco_search_committee}
\title{Search Committee}
\usage{
search_committee(search_string, term_id = NULL, exact = TRUE, verbose = TRUE)

legco_search_committee(
  search_string,
  term_id = NULL,
  exact = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{search_string}{search string of committee name. Accepts Chinese or
English full or partial name. Defaults to \code{NULL}.}

\item{term_id}{the id of a term, or a vector of ids. If \code{NULL}, returns
results of all terms. Defaults to \code{NULL}.}

\item{exact}{logical: Whether to look for exact match of the search term.
Defaults to \code{TRUE}.}

\item{verbose}{logical: Whether to display progress messages when fetching
data? Defaults to \code{TRUE}.}
}
\description{
Search committee by full or partial name of committee.
}
\details{
This is a complementary function to \code{\link{voting_record}()}.
}
\section{Functions}{
 Complementary Functions: \itemize{ \item
  \code{\link{search_committee}}: Search LegCo committees \item
  \code{\link{search_member}}: Search LegCo members \item
  \code{\link{search_voting_record}}: Search Voting Record in LegCo meetings
  \item \code{\link{search_question}}: Search full text of question put to
  the government by LegCo members}
}

\section{Notes}{
 The complementary functions work by calling a number of
  database functions and combining their output, meaning that a function call
  usually involves multiple API calls. Use with caution to prevent reaching
  the API’s rate limit too quickly.
}

