% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popchar.R
\name{sf_distrib}
\alias{sf_distrib}
\title{Test Overdispersion and Zero Inflation in Size and Fecundity Distributions}
\usage{
sf_distrib(
  data,
  sizea = NA,
  sizeb = NA,
  sizec = NA,
  obs3 = NA,
  fec = NA,
  repst = NA,
  zisizea = TRUE,
  zisizeb = TRUE,
  zisizec = TRUE,
  zifec = TRUE,
  fectime = 2,
  show.size = TRUE,
  show.fec = TRUE
)
}
\arguments{
\item{data}{A historical vertical data file, which is a data frame of class
\code{hfvdata}.}

\item{sizea}{A vector holding the name or column number of the variables
corresponding to primary size in occasions \emph{t}+1 and \emph{t}. Input 
only if \code{sizea} is to be tested.}

\item{sizeb}{A vector holding the name or column number of the variables
corresponding to secondary size in occasions \emph{t}+1 and \emph{t}. Input 
only if \code{sizeb} is to be tested.}

\item{sizec}{A vector holding the name or column number of the variables
corresponding to tertiary size in occasions \emph{t}+1 and \emph{t}. Input 
only if \code{sizec} is to be tested.}

\item{obs3}{The name or column number of the variable corresponding to
observation status in occasion \emph{t}+1. This should be used if observation
status will be used as a vital rate to absorb states of size = 0.}

\item{fec}{A vector holding the names or column numbers of the variables
corresponding to in occasions \emph{t}+1 and \emph{t}. Input only if 
\code{fec} is to be tested.}

\item{repst}{A vector holding the names or column numbers of the variables
corresponding to reproductive status in occasions \emph{t}+1 and \emph{t}.
If not provided, then fecundity will be tested without subsetting to only
reproductive individuals.}

\item{zisizea}{A logical value indicating whether to conduct a test of zero
inflation in primary size. Defaults to \code{TRUE}.}

\item{zisizeb}{A logical value indicating whether to conduct a test of zero
inflation in secondary size. Defaults to \code{TRUE}.}

\item{zisizec}{A logical value indicating whether to conduct a test of zero
inflation in tertiary size. Defaults to \code{TRUE}.}

\item{zifec}{A logical value indicating whether to conduct a test of zero
inflation in fecundity. Defaults to TRUE.}

\item{fectime}{An integer indicating whether to treat fecundity as occurring
in time \emph{t} (\code{2}) or time \emph{t}+1 (\code{3}). Defaults to
\code{2}.}

\item{show.size}{A logical value indicating whether to show the output for
tests of size. Defaults to \code{TRUE}.}

\item{show.fec}{A logical value indicating whether to show the output for
tests of fecundity. Defaults to \code{TRUE}.}
}
\value{
Produces text describing the degree and significance of difference
from expected dispersion, and the degree and significance of zero inflation.
The tests are chi-squared score tests based on the expectations of 
mean = variance, and 0s as abundant as predicted by the value of lambda
estimated from the dataset. See van der Broek (1995) for more details.
}
\description{
Function \code{sf_distrib} takes a historically formatted vertical data as
input and tests whether size and fecundity data are dispersed according to a
Poisson distribution (where mean = variance), and whether the number of 0s
exceeds expectations. This function is now deprecated in favor of function
\code{\link{hfv_qc}()}.
}
\section{Notes}{

This function subsets the data in the same way as \code{\link{modelsearch}()}
before testing underlying distributions, making the output much more
appropriate than a simple analysis of size and fecundity variables in
\code{data}.

The specific test used for overdispersion is a chi-squared test of the
dispersion parameter estimated using a generalized linear model predicting
the response given size in occasion \emph{t}, under a quasi-Poisson
distribution.

The specific test used for zero-inflation is the chi-squared test presented
in van der Broek (1995).
}

\examples{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r",
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

sf_distrib(lathvertln, sizea = c("sizea3", "sizea2"), fec = c("feca3", "feca2"),
  repst = c("repstatus3", "repstatus2"), zifec = FALSE)

}
