% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lcp.R
\name{create_lcp}
\alias{create_lcp}
\title{Calculate Least Cost Path from Origin to Destination}
\usage{
create_lcp(
  cost_surface,
  origin,
  destination,
  directional = FALSE,
  cost_distance = FALSE
)
}
\arguments{
\item{cost_surface}{\code{TransitionLayer} (gdistance package). Cost surface to be used in Least Cost Path calculation}

\item{origin}{\code{SpatialPoints*} (sp package) location from which the Least Cost Path is calculated. Only the first row is taken into account}

\item{destination}{\code{SpatialPoints*} (sp package) location to which the Least Cost Path is calculated. Only the first row is taken into account}

\item{directional}{\code{logical}. if TRUE Least Cost Path calculated from origin to destination only. If FALSE Least Cost Path calculated from origin to destination and destination to origin. Default is FALSE}

\item{cost_distance}{\code{logical}. if TRUE computes total accumulated cost for each Least Cost Path. Default is FALSE}
}
\value{
\code{SpatialLinesDataFrame} (sp package) of length 1 if directional argument is TRUE or 2 if directional argument is FALSE. The resultant object is the shortest route (i.e. least cost) between origin and destination using the supplied \code{TransitionLayer}.
}
\description{
Calculates a Least Cost Path from an origin location to a destination location. Applies Dijkstra's algorithm.
}
\examples{
r <- raster::raster(system.file('external/maungawhau.grd', package = 'gdistance'))

slope_cs <- create_slope_cs(r, cost_function = 'tobler')

loc1 = cbind(2667670, 6479000)
loc1 = sp::SpatialPoints(loc1)

loc2 = cbind(2667800, 6479400)
loc2 = sp::SpatialPoints(loc2)

lcps <- create_lcp(cost_surface = slope_cs, origin = loc1,
destination = loc2, directional = FALSE, cost_distance = FALSE)
}
\references{
Dijkstra, E. W. (1959). A note on two problems in connexion with graphs. Numerische Mathematik. 1: 269-271.
}
\author{
Joseph Lewis
}
