% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lcp_density.R
\name{create_lcp_density}
\alias{create_lcp_density}
\title{create_lcp_density}
\usage{
create_lcp_density(lcps, raster, rescale = FALSE)
}
\arguments{
\item{lcps}{\code{SpatialLines} or \code{SpatialLinesDataFrame}. Least Cost Paths}

\item{raster}{\code{RasterLayer} (raster package). This is used to derive the resolution, extent, and spatial reference system to be used when calculating the cumulative least cost path raster}

\item{rescale}{if TRUE raster values scaled to between 0 and 1. Default is FALSE}
}
\value{
\code{RasterLayer} (raster package). The resultant object is the cumulatively combined Least Cost Paths. This identifies routes of preferential movement within the landscape.
}
\description{
Creates a cumulative least cost path raster
}
\details{
Cumulatively combines Least Cost Paths in order to identify routes of preferential movement within the landscape.
}
\examples{

r <- raster::raster(nrow=50, ncol=50,  xmn=0, xmx=50, ymn=0, ymx=50, crs='+proj=utm')

r[] <- stats::runif(1:length(r))

slope_cs <- create_slope_cs(r, cost_function = 'tobler')

x1 <- c(seq(1,10), seq(11,25), seq(26,30))
y1 <- c(seq(1,10), seq(11,25), seq(26,30))
line1 <- sp::SpatialLines(list(sp::Lines(sp::Line(cbind(x1,y1)), ID='a')))

x2 <- c(seq(1,10), seq(11,25), seq(26, 30))
y2 <- c(seq(1,10), seq(11,25), rep(25, 5))
line2 <- sp::SpatialLines(list(sp::Lines(sp::Line(cbind(x2,y2)), ID='b')))

lcp_network <- rbind(line1, line2)

cumulative_lcps <- create_lcp_density(lcps = lcp_network, raster = r, rescale = FALSE)
}
\author{
Joseph Lewis
}
