% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDS_reconstruction.R
\name{call_method}
\alias{call_method}
\title{Call a reconstruction method}
\usage{
call_method(
  y,
  u,
  v,
  method,
  init,
  num.restarts,
  return.init,
  ub,
  lb,
  num.islands,
  pop.per.island,
  niter,
  tol
)
}
\arguments{
\item{y}{Catchment output, preprocessed from data}

\item{u}{Input matrix for a single-model reconstruction, or a list of input matrices for an ensemble reconstruction.}

\item{v}{Same as u.}

\item{method}{By default this is "EM". There are experimental methods but you should not try.}

\item{init}{A list, each element is a vector of initial values for the parameters. If \code{NULL}, will be created by \code{make_init()}. See \link{make_init} for details.}

\item{num.restarts}{The number of initial conditions to start the EM search; ignored if \code{init} is provided.}

\item{return.init}{If \code{TRUE}, the list of initial values (\code{init}) will be returned. This can be useful if you want to reproduce the model from this one set of initial values.}

\item{ub}{Upper bounds, a vector whose length is the number of parameters}

\item{lb}{Lower bounds}

\item{num.islands}{Number of islands (if method is GA; experimental)}

\item{pop.per.island}{Initial population per island (if method is GA; experimental)}

\item{niter}{Maximum number of iterations, default 1000}

\item{tol}{Tolerance for likelihood convergence, default 1e-5. Note that the log-likelihood is normalized by dividing by the number of observations.}
}
\value{
The results as produced by \code{LDS_EM_restart()} when the default method (EM) is called. Other methods are experimental.
}
\description{
Call a reconstruction method subroutine according to the method required
}
