% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunkwise.R
\name{chunkwise}
\alias{chunkwise}
\title{Process an lvec in chunks}
\usage{
chunkwise(x, init, update, final, ...)
}
\arguments{
\item{x}{the \code{\link{lvec}}.}

\item{init}{initialisation function. This function should accept an 
\code{\link{lvec}} as its first argument and return an initial value
for the state.}

\item{update}{update function. Called for each chunk of data. Receives 
the current value of the state as its first argument and the next chunk
of data as its second argument. Should return an updated state. This 
function can be called multiple times.}

\item{final}{finaliser function. Is called after processing the complete
lvec. Receives the final state as its first argument. Should return the 
end result.}

\item{...}{optional arguments passed on to the supplied functions.}
}
\description{
Process an lvec in chunks
}
\details{
For examples of its use see \code{\link{mean.lvec}} and 
\code{\link{sum.lvec}}.
}
