% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_exhaustive.R
\name{.sort_group_sizes}
\alias{.sort_group_sizes}
\title{Orders rows by similarity to expected group size proportions.}
\usage{
.sort_group_sizes(grpsizes, grpnames, props)
}
\arguments{
\item{grpsizes}{A data.table with the columns containing the group names,
and the rows containing a particular setup of group sizes.
All rows are expected to have the same sum (not checked).}

\item{grpnames}{The group names (specified because the table can have other
columns as well).}

\item{props}{Either the desired proportions (percentage) of the
sample for each condition as a named vector,
or the names of the conditions
for which we prefer to preserve the subjects,
in decreasing order of preference. If not specified, the
(full) sample proportions are used.
This is preferred among configurations with the same
taken into account by the other methods to some extent.
For example, c(A = 0.4, B = 0.4, C = 0.2) means that
we would like the number of subjects in groups A, B, and
C to be around 40\%, 40\%, and 20\% of the total number of
subjects, respectively. Whereas c("A", "B", "C") means
that if possible, we would like to keep all subjects
in group A, and prefer keeping subjects in B, even if
it results in losing more subjects from C.}
}
\description{
Orders rows by similarity to expected group size proportions.
}
\keyword{internal}
