% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_param.R
\name{extract_param}
\alias{extract_param}
\title{Extract labelled parameters of lavaan objects}
\usage{
extract_param(lavaan_object, printp = FALSE)
}
\arguments{
\item{lavaan_object}{lavaan object.}

\item{printp}{If TRUE convert into easily readable p values.}
}
\value{
This function returns a tibble with labelled parameters.
}
\description{
Extract labelled parameters of lavaan objects
}
\examples{
# First create a lavaan object
bi_lcsm_01 <- fit_bi_lcsm(data = data_bi_lcsm, 
                          var_x = names(data_bi_lcsm)[2:4], 
                          var_y = names(data_bi_lcsm)[12:14],
                          model_x = list(alpha_constant = TRUE, 
                                         beta = TRUE, 
                                         phi = FALSE),
                          model_y = list(alpha_constant = TRUE, 
                                         beta = TRUE, 
                                         phi = TRUE),
                          coupling = list(delta_lag_xy = TRUE, 
                                          xi_lag_yx = TRUE)
                                          )

# Now extract parameter estimates              
extract_param(bi_lcsm_01)
}
\references{
David Robinson and Alex Hayes (2019). broom: Convert Statistical Analysis Objects into Tidy Tibbles. R package version 0.5.2.
\url{https://CRAN.R-project.org/package=broom/}
}
