% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{liouv.Tau}
\alias{liouv.Tau}
\title{Computes Kendall's tau for Clayton or Gumbel Liouville copula}
\usage{
liouv.Tau(theta, family, alphavec)
}
\arguments{
\item{theta}{parameter of the corresponding Archimedean copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"} or \code{"gumbel"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}
}
\value{
vector of \eqn{\tau}{tau}
}
\description{
The function computes Kendall's \eqn{\tau}{tau} for the given model, given \code{alphavec}
}
\examples{
liouv.Tau(theta=2, family="gumbel", alphavec=c(1,2))
liouv.Tau(theta=1, family="clayton", alphavec=c(2,1))
}

