% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brunner.munzel.test.R
\name{brunner.munzel.test}
\alias{brunner.munzel.test}
\title{Brunner--Munzel Test for Stochastic Equality}
\usage{
brunner.munzel.test(x, y, alternative = c("two.sided", "greater",
  "less"), alpha = 0.05)
}
\arguments{
\item{x}{the numeric vector of data values from the sample 1.}

\item{y}{the numeric vector of data values from the sample 2.}

\item{alternative}{a character string specifying the alternative hypothesis, 
must be one of \code{"two.sided"} (default), \code{"greater"} or 
\code{"less"}. User can specify just the initial letter.}

\item{alpha}{significance level, default is 0.05 for 95\% confidence interval.}
}
\value{
A list of class \code{"htest"} with the following components:
\item{statistic}{the Brunner--Munzel test statistic.}
\item{parameter}{the degrees of freedom.}
\item{conf.int}{the confidence interval.}
\item{p.value}{the \eqn{p}-value of the test.}
\item{data.name}{a character string giving the name of the data.}
\item{estimate}{an estimate of the effect size, i.e., \eqn{P(X < Y) + 0.5 \times P(X =Y )}.}
}
\description{
The Brunner--Munzel test for stochastic equality of two samples, 
which is also known as the Generalized Wilcoxon Test. 
\code{NA}s from the data are omitted.
}
\details{
There exist discrepancies with \insertCite{Brunner_Munzel_2000;textual}{lawstat}
because there is a typo in the paper. The corrected version is in 
\insertCite{Neubert_Brunner_2007;textual}{lawstat}
(e.g., compare the estimates for the case study on pain scores). 
The current function follows \insertCite{Neubert_Brunner_2007;textual}{lawstat}.
}
\examples{
## Pain score on the third day after surgery for 14 patients under
## the treatment Y and 11 patients under the treatment N
## (see Brunner and Munzel, 2000; Neubert and Brunner, 2007).

Y <- c(1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 1, 1)
N <- c(3, 3, 4, 3, 1, 2, 3, 1, 1, 5, 4)

brunner.munzel.test(Y, N)

##       Brunner-Munzel Test
## data: Y and N
## Brunner-Munzel Test Statistic = 3.1375,  df = 17.683, p-value = 0.005786
## 95 percent confidence interval:
##  0.5952169 0.9827052
## sample estimates:
## P(X<Y)+.5*P(X=Y)
##        0.788961

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{wilcox.test}}, \code{\link[stats]{pwilcox}}
}
\author{
Wallace Hui, Yulia R. Gel, Joseph L. Gastwirth, Weiwen Miao. 
This function was updated with the help of Dr. Ian Fellows.
}
\keyword{htest}
\keyword{nonparametric}
