% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_grid.R
\name{lawn_point_grid}
\alias{lawn_point_grid}
\title{Create a PointGrid}
\usage{
lawn_point_grid(extent, cellSide, units = "kilometers", mask = NULL)
}
\arguments{
\item{extent}{(numeric) Extent in \verb{[minX, minY, maxX, maxY]} order.}

\item{cellSide}{(integer) the distance between points}

\item{units}{(character) Units to use for cellWidth, one of 'miles' or
'kilometers' (default).}

\item{mask}{(logical) if passed a Polygon or MultiPolygon, the grid
Points will be created only inside it}
}
\value{
\link{data-FeatureCollection} grid of points.
}
\description{
Takes a bounding box and a cell depth and returns a set of
\link{data-Point}'s in a grid
}
\note{
parameters \code{centered} and \code{bboxIsMask} removed
}
\examples{
lawn_point_grid(c(-77.3876, 38.7198, -76.9482, 39.0277), 30, 'miles')
lawn_point_grid(c(-77.3876, 38.7198, -76.9482, 39.0277), 10, 'miles')
lawn_point_grid(c(-77.3876, 38.7198, -76.9482, 39.0277), 3, 'miles')
}
\seealso{
Other interpolation: 
\code{\link{lawn_hex_grid}()},
\code{\link{lawn_isolines}()},
\code{\link{lawn_planepoint}()},
\code{\link{lawn_square_grid}()},
\code{\link{lawn_tin}()},
\code{\link{lawn_triangle_grid}()}
}
\concept{interpolation}
