% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean_overlap.R
\name{lawn_boolean_overlap}
\alias{lawn_boolean_overlap}
\title{Boolean overlap}
\usage{
lawn_boolean_overlap(feature1, feature2, lint = FALSE)
}
\arguments{
\item{feature1, feature2}{any data-Geometry/data-Feature(
data-LineString|data-MultiLineString|data-Polygon|data-MultiPolygon) objects}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a logical (\code{TRUE}/\code{FALSE})
}
\description{
Boolean overlap
}
\examples{
poly1 <- "[[[0,0],[0,5],[5,5],[5,0],[0,0]]]"
poly2 <- "[[[1,1],[1,6],[6,6],[6,1],[1,1]]]"
poly3 <- "[[[10,10],[10,15],[15,15],[15,10],[10,10]]]"
lawn_boolean_overlap(lawn_polygon(poly1), lawn_polygon(poly2))
lawn_boolean_overlap(lawn_polygon(poly2), lawn_polygon(poly3))
}
\seealso{
Other boolean functions: 
\code{\link{lawn_boolean_clockwise}()},
\code{\link{lawn_boolean_contains}()},
\code{\link{lawn_boolean_crosses}()},
\code{\link{lawn_boolean_disjoint}()},
\code{\link{lawn_boolean_pointonline}()},
\code{\link{lawn_boolean_within}()}
}
\concept{boolean functions}
