% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_translate.R
\name{lawn_transform_translate}
\alias{lawn_transform_translate}
\title{Translate a GeoJSON feature}
\usage{
lawn_transform_translate(x, distance, direction, units = "kilometers",
  zTranslation = 0, mutate = FALSE, lint = FALSE)
}
\arguments{
\item{x}{a feature}

\item{distance}{(integer/numeric) length of the motion; negative values
determine motion in opposite direction}

\item{direction}{(integer/numeric) of the motion; angle from North in
decimal degrees, positive clockwise}

\item{units}{(character) in which distance will be express; miles,
kilometers, degrees, or radians (optional, default kilometers)}

\item{zTranslation}{(integer/numeric) length of the vertical motion,
same unit of distance (optional, default 0)}

\item{mutate}{(logical) allows GeoJSON input to be mutated (significant
performance increase if true) (optional). Default: \code{FALSE}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a changed \link{data-Feature}
}
\description{
Moves any geojson Feature or Geometry of a specified distance along a
Rhumb Line on the provided direction angle.
}
\examples{
x <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
   "type": "Polygon",
   "coordinates": [
    [
      [ 0, 29 ], [ 3.5, 29 ], [ 2.5, 32 ], [ 0, 29 ]
    ]
  ]
 }
}'
lawn_transform_translate(x, distance = 100, direction = 35)

lawn_transform_translate(x, distance = 100, direction = 24)
lawn_transform_translate(x, distance = 100, direction = 24, mutate = TRUE)

\dontrun{
view(lawn_featurecollection(x))
view(lawn_featurecollection(
  lawn_transform_translate(x, distance = 130, direction = 35,
   units = "kilometers")
))
view(lawn_featurecollection(
  lawn_transform_translate(x, distance = 130, direction = -35,
   units = "kilometers")
))
view(lawn_featurecollection(
  lawn_transform_translate(x, distance = 130, direction = 35,
   units = "kilometers", zTranslation = 10)
))
view(lawn_featurecollection(
  lawn_transform_translate(x, distance = 130, direction = 35,
   units = "kilometers", mutate = TRUE)
))
}
}
