% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{lawn_sample}
\alias{lawn_sample}
\title{Return features from FeatureCollection at random}
\usage{
lawn_sample(features = NULL, n = 100, lint = FALSE)
}
\arguments{
\item{features}{A FeatureCollection}

\item{n}{(integer) Number of features to generate}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
A \code{\link{data-FeatureCollection}}
}
\description{
Takes a \code{\link{data-FeatureCollection}} and returns a
\code{\link{data-FeatureCollection}} with given number of features at random
}
\examples{
lawn_sample(lawn_data$points_average, 1)
lawn_sample(lawn_data$points_average, 2)
lawn_sample(lawn_data$points_average, 3)
}
\seealso{
Other data functions: \code{\link{lawn_featurecollection}},
  \code{\link{lawn_feature}}, \code{\link{lawn_filter}},
  \code{\link{lawn_geometrycollection}},
  \code{\link{lawn_linestring}},
  \code{\link{lawn_multilinestring}},
  \code{\link{lawn_multipoint}},
  \code{\link{lawn_multipolygon}},
  \code{\link{lawn_point}}, \code{\link{lawn_polygon}},
  \code{\link{lawn_random}}, \code{\link{lawn_remove}}
}

