% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_ind.R
\name{lavaan_ind}
\alias{lavaan_ind}
\title{Extract relevant indirect effects indices from lavaan model}
\usage{
lavaan_ind(
  fit,
  estimate = "B",
  nice_table = FALSE,
  underscores_to_arrows = TRUE,
  ...
)
}
\arguments{
\item{fit}{lavaan fit object to extract fit indices from}

\item{estimate}{What estimate to use, either the standardized
estimate ("B", default), or unstandardized
estimate ("b").}

\item{nice_table}{Logical, whether to print the table as a
\code{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}

\item{underscores_to_arrows}{Logical, whether to convert underscore
to arrows in the "Indirect Effect column".}

\item{...}{Arguments to be passed to \code{rempsyc::nice_table}}
}
\value{
A dataframe, including the indirect effect ("lhs"),
corresponding paths ("rhs"), standardized regression
coefficient ("std.all"), corresponding p-value, as well
as the unstandardized regression coefficient ("est") and
its confidence interval ("ci.lower", "ci.upper").
}
\description{
Extract relevant indirect effects indices from lavaan model
through \verb{lavaan::parameterEstimates)} with
\code{standardized = TRUE}. In this case, the beta (B) represents
the resulting \code{std.all} column. See "Value" section for more
details.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
(latent <- list(visual = paste0("x", 1:3),
                textual = paste0("x", 4:6),
                speed = paste0("x", 7:9)))

(mediation <- list(speed = "visual",
                   textual = "visual",
                   visual = c("ageyr", "grade")))

(indirect <- list(IV = c("ageyr", "grade"),
                  M = "visual",
                  DV = c("speed", "textual")))

HS.model <- write_lavaan(mediation, indirect = indirect,
                         latent = latent, label = TRUE)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data=HolzingerSwineford1939)
lavaan_ind(fit)
\dontshow{\}) # examplesIf}
}
\keyword{CFA}
\keyword{analysis}
\keyword{equation}
\keyword{lavaan}
\keyword{modeling}
\keyword{path}
\keyword{structural}
