% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-hessian2.R
\name{hessian2}
\alias{hessian2}
\alias{hessian2.lvmfit}
\alias{hessian2.lvmfit2}
\title{Hessian With Small Sample Correction.}
\usage{
hessian2(object, indiv, cluster, as.lava, ...)

\method{hessian2}{lvmfit}(
  object,
  indiv = FALSE,
  cluster = NULL,
  as.lava = TRUE,
  ssc = lava.options()$ssc,
  ...
)

\method{hessian2}{lvmfit2}(object, indiv = FALSE, cluster = NULL, as.lava = TRUE, ...)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{indiv}{[logical] If \code{TRUE}, the hessian relative to each observation is returned. Otherwise the total hessian is returned.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{as.lava}{[logical] if \code{TRUE}, uses the same names as when using \code{stats::coef}.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (\code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}
}
\value{
An array containing the second derivative of the likelihood relative to each sample (dim 3)
and each pair of model coefficients (dim 1,2).
}
\description{
Extract the hessian from a latent variable model, with small sample correction
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the hessian.
}
\examples{
#### simulate data ####
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- Sequence.lvm(0)
set.seed(10)
d <- lava::sim(m,n)

#### latent variable models ####
e.lvm <- estimate(lvm(formula.lvm),data=d)
hessian2(e.lvm)

}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{small sample inference}
