% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{ggManifoldMap}
\alias{ggManifoldMap}
\title{Visualize an embedding by ggplotting with images}
\usage{
ggManifoldMap(ggObject = NULL, x, n = nrow(x), images, scale = 1)
}
\arguments{
\item{ggObject}{a \code{\link[ggplot2]{ggplot}} object.  If not provided, a new \code{ggplot}
object with \code{\link[ggplot2]{geom_blank}} will be created.}

\item{x}{A \code{largeVis} object or [N,D] matrix of coordinates.}

\item{n}{The number of images to sample.}

\item{images}{The images. A 3-D or 4-D array.}

\item{scale}{Proportion to scale the images to.}
}
\value{
A \code{ggplot} object.
}
\description{
Identical to \link{manifoldMap}, but adds images to an existing \code{ggplot2} object or creates one.
}
\details{
See \code{\link{manifoldMap}}.  Note that this function can be considerably slower to display than \code{manifoldMap}.
It therefore should only be used if other features of \code{ggplot2} are required.

If the objects in the list are \code{matrix} objects, or the array is 3-dimensional, the images will be treated as
greyscale. If there is an additional dimension, it must have a length of 3 and be RGB color layers.
}
