% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outlier_turkey}
\alias{outlier_turkey}
\title{Outliers: Tukey’s fences}
\usage{
outlier_turkey(x, k = 1.5)
}
\arguments{
\item{x}{Numeric. Distribution}

\item{k}{Positive Numeric. K-multiplier.}
}
\value{
Boolean vector detecting outliers.
}
\description{
Tukey’s fences is a technique used in box plots. The non-outlier
range is defined with \code{[Q1-k(Q3-Q1), Q3+k(Q3-Q1)]}, where Q1 and Q3
are the lower and upper quartiles respectively, k - some non-negative
constant (popular choice is 1.5). A value is an outlier based
on Tukey’s fences when its value does not lie in non-outlier range.
}
\seealso{
Other Outliers: 
\code{\link{outlier_zscore_plot}()},
\code{\link{outlier_zscore}()},
\code{\link{winsorize}()}
}
\concept{Outliers}
