% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onehotencoding.R
\name{date_feats}
\alias{date_feats}
\title{One Hot Encoding for Date/Time Variables (Dummy Variables)}
\usage{
date_feats(
  dates,
  keep_originals = FALSE,
  only = NA,
  features = TRUE,
  holidays = FALSE,
  country = "Venezuela",
  currency_pair = NA,
  quiet = FALSE
)
}
\arguments{
\item{dates}{Vector or dataframe. Non-date/time columns will be 
automatically ignored/extracted.}

\item{keep_originals}{Boolean. Should the original date/time columns be
kept in the results? Only valid when input is a dataframe.}

\item{only}{Character or vector. Which columns do you wish to process? If
non are explicitly defined, all will be processed}

\item{features}{Create features out of date/time columns?}

\item{holidays}{Boolean. Include holidays as new columns?}

\item{country}{Character or vector. For which countries should the holidays
be included?}

\item{currency_pair}{Character. Which currency exchange do you
wish to get the history from? i.e, USD/COP, EUR/USD...}

\item{quiet}{Boolean. Quiet all messages?}
}
\value{
data.frame with additional features calculated out of time or date vectors.
}
\description{
This function lets the user automatically create new columns out
of a dataframe or vector with date/time variables.
}
\examples{
df <- data.frame(
  dates = sample(seq(Sys.Date() - 365, Sys.Date(), by = 1), 50),
  times = sample(seq(Sys.time() - 1e7, Sys.time(), by = 1), 50))
  
# Input as a vector or dataframe
date_feats(df, keep_originals = TRUE) \%>\% head(10)

# Holidays given a date range and country
\donttest{
  hol <- date_feats(
    seq(Sys.Date() - 365, Sys.Date(), by = 1), 
    keep_originals = TRUE, 
    holidays = TRUE, 
    country = "Colombia")
  head(hol[!is.na(hol$holidayname),])
}
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{formatNum}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{numericalonly}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{removenarows}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{year_week}()}

Other Feature Engineering: 
\code{\link{holidays}()},
\code{\link{ohse}()}

Other One Hot Encoding: 
\code{\link{holidays}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()}
}
\concept{Data Wrangling}
\concept{Feature Engineering}
\concept{One Hot Encoding}
