% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeMinorMajorAxisRatio.R
\name{lakeMinorMajorRatio}
\alias{lakeMinorMajorRatio}
\title{Calculate the ratio of the minor axis length to major axis length}
\usage{
lakeMinorMajorRatio(inLakeMorpho, addLine = TRUE)
}
\arguments{
\item{inLakeMorpho}{An object of \code{\link{lakeMorphoClass}}.  Output of the 
\code{\link{lakeSurroundTopo}} function would be appropriate as input}

\item{addLine}{Boolean to determine if the selected major and minor axis lines
should be added to the inLakeMorpho object.  Defaults to True}
}
\value{
This returns a vector of numeric values indicating the length of the
        major and minor axes of the lake. Units are the same as the input data.
}
\description{
Major axis length is defined as the maximum length spanning the convex hull
of a lake. Minor axis length is defined as the minimum length spanning the
convex hull of a lake.
}
\examples{
data(lakes)
lakeMinorMajorRatio(inputLM)
plot(inputLM$lake)
lines(inputLM$majoraxisLengthLine)
lines(inputLM$minoraxisLengthLine)
}
\references{
\href{https://en.wikipedia.org/wiki/Semi-major_and_semi-minor_axes}{Link}
}

