% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_demo_data.R
\name{make_demo_data}
\alias{make_demo_data}
\title{Construct a Fake Demographic Data Frame}
\usage{
make_demo_data(
  n = 1000,
  age.mean = 43,
  age.sd = 15,
  gend.prob = c(0.475, 0.475, 0.05),
  raceth.prob = c(1/7, 1/7, 1/7, 1/7, 1/7, 1/7, 1/7),
  edu.prob = c(0.03, 0.32, 0.29, 0.24, 0.12),
  rownames = TRUE
)
}
\arguments{
\item{n}{number of observations (rows) of hypothetical data set to create.}

\item{age.mean}{mean value of (fictional) age variable (assuming a normal
distribution) recorded in a hypothetical data set.}

\item{age.sd}{standard deviation of (fictional) age variable (assuming a normal
distribution) recorded in a hypothetical data set.}

\item{gend.prob}{probabilities of three gender categories for a gender identity
variable recorded in a hypothetical data set.}

\item{raceth.prob}{probabilities of categories of a hypothetical race/ethnicity
variable recorded in a hypothetical data set.}

\item{edu.prob}{probabilities of categories of a hypothetical "highest level of
education" variable recorded in a hypothetical data set.}

\item{rownames}{create memorable but arbitrary rownames for inspection (if
TRUE).}
}
\value{
a data.frame.
}
\description{
\code{make_demo_data} generates a data.frame with select (entirely fictional)
"demographic" variables purely for the purposes of demonstrating or exploring
common labelr behaviors and uses and is not designed to accurately emulate or
represent the frequencies or relationships among demographic variables.
}
\examples{
# make toy demographic (gender, race, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000)
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)
head(df)
summary(df)
}
