% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtwv.R
\name{a2d}
\alias{a2d}
\alias{agrid}
\alias{best.cor}
\alias{df2mt}
\alias{efg}
\alias{getwave}
\alias{getwavf}
\alias{spikes.2d}
\alias{markspikes}
\title{Internal Functions For \code{kzpdr}, \code{kzp2}, \code{kz.ft}, and \code{kzrc2}}
\usage{
a2d(a)

agrid(df, scale, math = "mean")

best.cor(rc, sig, ...)

df2mt(df, scale)

efg(f, d, ag)

getwave(df, angle, cp = 0)

getwavf(df, angle, f1, rlvl = 1)

spikes.2d(x.fq, y.spm, nm = 10)

markspikes(x.fq, y.spm, plot = TRUE, ...)
}
\arguments{
\item{a}{2D array for position and signal values.}

\item{df}{Data frame of signal values and positions.}

\item{scale}{Vector for scale of each dimension. For example,
for a \emph{x * y} grid, the scale is \emph{c(1/x, 1/y)}.}

\item{math}{Function to aggregate the data. Defaults to "mean".}

\item{rc}{Array. Reconstructed signal.}

\item{sig}{Array. Original signal (without noise).}

\item{...}{Other arguments, i.e. the "cut" threshold, etc.
\itemize{
\item    \code{ cut : }  
    Set the minimum value for a marked frequency spike. Recommend to
    use argument \code{lvl} instead of setting this value directly.
\item    \code{ lvl : }
    "min" or "max". Threshold strategy for marking frequency spikes.
    Essentially it will set the "cut" threshold value as different
    level. "min" is used for cases of weak singles dominating by 
    some strong singles. Defaults to "max". 
}}

\item{f}{Wave frequency.}

\item{d}{Wave direction.}

\item{ag}{Sampling direction.}

\item{angle}{Direction or vector of directions in radians.}

\item{cp}{Sampling scheme. Values 0, 2, and others : normal;
1: interpolation; 3: errors}

\item{f1}{Wave frequency}

\item{rlvl}{Coefficient to control the averaging level.}

\item{x.fq}{Vector of frequency values for x axis.}

\item{y.spm}{Vector of spectrum values for y axis.}

\item{plot}{If need to add marks on the periodogram. Defaults to TRUE.}

\item{angle}{Wave direction}
}
\description{
A group of internal functions used by \code{kzpdr}, \code{kzp2}, \code{kz.ft}, 
  and \code{kzrc2}.
\itemize{

  \item \code{a2d} transfers 2D array to data frame. If input is data 
	frame, it will return the original data frame.


  \item \code{agrid} aggregates data based on given grid scale.

  \item \code{best.cor} returns the largest correlation and related 
  lags on x- or y-direction for two image matrices.

  \item \code{df2mt} transfers data frame to matrix.

  \item \code{efg} gives projected wave frequency on given direction.


  \item \code{getwave} is designed to extract data series along a given
	direction in a 2D field.

  \item \code{getwavf} extracts data series along a given direction in
	a 2D field with phase arranged according to the wave frequency.

  \item \code{markspikes} and \code{spikes.2d} are functions to mark the 
 	spikes of the 1D periodogram and 2D periodogram, respectively.
 

}
}
\keyword{internal}
