% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drsp.R
\name{kzpdr}
\alias{kzpdr}
\alias{kzpdr.3d}
\title{Average Periodogram for Spatial Data in Given Directions}
\usage{
kzpdr(ds, angle, plot = F, pair = T, ...)

kzpdr.3d(ds, angle, ...)
}
\arguments{
\item{ds}{Data array. Only 2 dimensional arrays are allowed for current version.}

\item{angle}{Vector or single numeric value in radians.}

\item{plot}{TRUE or FLASE. Flag for outputting designed periodogram plot or not.
       Defaults to FLASE. In \code{kzpdr}, the plot is the mean periodogram 
for data series in a given direction.}

\item{pair}{Logic. Defaults to TRUE, i.e., check the given directions and their
orthogonal opposition at the same time.}

\item{...}{Other arguments. 
\itemize{
 \item     For function \code{kzpdr}, it could be the following arguments
    (right of equals signs are their default setting):
\itemize{
 \item  \code{w = 20 : } smoothing window size.
 \item  \code{dpct = 0.01 : } a percentage of total variation of periodogram;
      smoothing window is extended until variation within the window 
      reaches this number. See DZ method in \code{kzft::kzp} for details.
 \item  \code{rg = c(0,0.5) : } the frequency range for the periodogram.
 \item  \code{raw = FALSE : } if use the raw periodogram directly. 
 \item  \code{log = FALSE : } if use log scale for periodogram.
 \item  \code{frun = FALSE :} if force to run the sampling on given directions.
      Defaults to check records and not sample on duplicate directions
 \item  \code{min.ln = 0.6 :} the minimum ratio of sampling data length vs. 
      original data length to product a periodogram for a direction.
}    

 \item    In \code{kzpdr.3d} function, it could be arguments of 
    the perspective plot, like \code{theta}, \code{phi}, etc.,
    please refer function \code{graphics::persp} for more 
    information.

 \item    For \code{kzpdr.valid}, \code{level} control the cross-validation
    process: integer number \code{k} means to run cross-validation
    by excluding \code{k} pairs of directional samples each time. 
    Default value is 1.
}}
}
\value{
The returned data list of function \code{kzpdr} includes the 
	data frame for frequencies of spikes on mean periodograms of each
	checked direction. It also includes a vector recording the md5sum
	value of the spatial wave data array for internal control.

	    Function \code{kzpdr} will output the periodogram plots when 
	option \code{plot} is set as TRUE. The frequencies of marked spikes 
	will also be print out for each sampling direction.
		
	    \code{kzpdr.3d} returns back the data frame for re-gridded mean 
		periodogram for data series in given direction, as showed in the 
	perspective plot.
}
\description{
Functions in this group are designed to check periodogram for data series 
in a given direction or a list of directions. 

   \code{kzpdr} samples the data of wave field, and outputs the average
pattern of periodogram for series in a given direction. A collection of 
these pattern records will be sent to \code{kzpdr.eval} or \code{kzpdr.estimate} 
to estimate the wave frequencies and directions.
}
\details{
\code{kzpdr} is used to sample the spatial data and generates 
	periodograms in orthogonal direction pairs; the frequencies of spikes 
	for each directional periodogram are identified and recorded as the 
	function output. The spike pattern of average periodograms for spatial
	directions can help to identify wave frequencies and directions.

	    Function \code{kzpdr.3d} will provide 3D perspective plot as the   
	global view for periodograms of data series in a given direction.
}
\examples{
dx <- 300			 
dy <- 300			 

b <- expand.grid(x=1:dx, y=1:dy)
q1 <- pi/3; f1 <- 0.2;
b$v1 <- sin(f1*2*pi*(b$x*cos(q1)+b$y*sin(q1))+100*runif(1))
q2 <- pi/6; f2 <- 0.05;
b$v2 <- sin(f2*2*pi*(b$x*cos(q2)+b$y*sin(q2))+100*runif(1))

a <- array(0,c(dx,dy))
a[as.matrix(b[,1:2])] <- b$v1 + 1.5*b$v2
persp(1:dx, 1:dy, a, theta=90, phi=-110, 
	ticktype="detailed", col="lightblue")
a <- a + 5*matrix(rnorm(dx*dy,0,1),ncol=dy)
persp(1:dx, 1:dy, a, theta=90, phi=-110, 
	ticktype="detailed", col="lightblue")

# It may take about 30 seconds
# o <- kzpdr.3d(a, -pi/6) 

# Load pre-saved data to save running-time
data(kzpdr.demo);

# sampling, it may take a few minutes 
# system.time(kzpdr.demo <- kzpdr(a, pi/12, pair=FALSE, plot=TRUE)) 
# system.time(kzpdr.demo <- kzpdr(a, pi/12, plot=TRUE))
# system.time(kzpdr.demo <- kzpdr(a, c(0, pi/6, pi/4, pi/3), plot=TRUE))
 
kzpdr.spikes(kzpdr.demo)

# For identification of the wave parameters, see kzpdr.estimate
}
\seealso{
\code{\link{kzp2}}, \code{\link{kzpdr.tol}}, \code{\link{kzpdr.eval}}
  			\code{\link{kzpdr.valid}}, \code{\link{kzpdr.spikes}}
}
\concept{
Kolmogorov-Zurbenko periodogram

directional periodogram

average periodogram
}
\keyword{directional-periodogram}
