% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_sdp.R
\name{create.solve_sdp}
\alias{create.solve_sdp}
\title{Optimization for fixed-X and Gaussian knockoffs}
\usage{
create.solve_sdp(Sigma, gaptol = 1e-06, maxit = 1000, verbose = FALSE)
}
\arguments{
\item{Sigma}{positive-definite p-by-p covariance matrix.}

\item{gaptol}{tolerance for duality gap as a fraction of the value of the objective functions (default: 1e-6).}

\item{maxit}{maximum number of iterations for the solver (default: 1000).}

\item{verbose}{whether to display progress (default: FALSE).}
}
\value{
The solution \eqn{s} to the semidefinite programming problem defined above.
}
\description{
This function solves the optimization problem needed to create fixed-X and Gaussian SDP knockoffs
on the full covariance matrix. This will be more powerful than \code{\link{create.solve_asdp}},
but more computationally expensive.
}
\details{
Solves the semidefinite programming problem:

  \deqn{ \mathrm{maximize}      \; \mathrm{sum}(s) \quad
          \mathrm{subject} \; \mathrm{to}    0 \leq s \leq 1, \;
                                 2\Sigma - \mathrm{diag}(s) \geq 0}

This problem is solved using the interior-point method implemented in \code{\link[Rdsdp]{dsdp}}.

If the matrix Sigma supplied by the user is a non-scaled covariance matrix 
(i.e. its diagonal entries are not all equal to 1), then the appropriate scaling is applied before
solving the SDP defined above. The result is then scaled back before being returned, as to match 
the original scaling of the covariance matrix supplied by the user.
}
\seealso{
Other optimization: \code{\link{create.solve_asdp}},
  \code{\link{create.solve_equi}}
}
