% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomass_nfi.R
\name{biomass_nfi}
\alias{biomass_nfi}
\title{Calculate Tree Biomass for National Forest Inventory Data}
\usage{
biomass_nfi(
  data,
  byplot = FALSE,
  plotgrp = NULL,
  treegrp = NULL,
  strat = "FORTYP_SUB",
  clusterplot = FALSE,
  largetreearea = TRUE,
  stockedland = TRUE,
  talltree = TRUE
)
}
\arguments{
\item{data}{: A \code{list} generated by \code{\link{read_nfi}} that contains 'plot' and 'tree' data frames.}

\item{byplot}{: A logical flag (default FALSE); if TRUE, calculates statistics for each plot separately. If FALSE, calculates for the entire dataset or groups specified by \code{plotgrp} and \code{treegrp}.}

\item{plotgrp}{: A character vector; variables from 'plot' tables for grouping. Use \code{c()} to combine multiple variables.}

\item{treegrp}{: A character vector; variables from 'tree' tables for grouping. Use \code{c()} to combine multiple variables.}

\item{strat}{: A character vector; the variable used for post-stratification. In the National Forest Inventory of Korea, it is typically used by forest type.}

\item{clusterplot}{: A logical flag (default FALSE); if TRUE, treats each cluster plot as a single unit. If FALSE, calculates for each subplot separately.}

\item{largetreearea}{: A logical flag (default TRUE); if TRUE, includes large tree survey plots in the analysis. If FALSE, only uses standard tree plots.}

\item{stockedland}{: A logical flag (default TRUE); if TRUE, includes only stocked land. If FALSE, includes all land types.}

\item{talltree}{: A logical flag (default TRUE); if TRUE, includes only tall trees. If FALSE, includes both trees and shrubs.}
}
\value{
A \code{data.frame} that includes biomass estimates.
The structure depends on the input parameters:
\itemize{
\item If \code{byplot = TRUE}, each row represents a plot.
\item If \code{byplot = FALSE}, each row represents the entire dataset or a group specified by \code{plotgrp} and \code{treegrp}
}
}
\description{
biomass_nfi() function estimates volume, aboveground biomass, biomass, carbon storage and carbon dioxide storage.
It can provide summaries for individual plots, the entire study area, or specific groups within the study area using parameters \code{byplot}, \code{plotgrp} and \code{treegrp}.
When calculating biomass at the individual trees and plots level, users have flexibility in specifying data inclusion criteria and analysis levels using parameters \code{clusterplot}, \code{largetreearea}, \code{stockedland}, and \code{talltree}.
These parameters determine whether to treat cluster plots as single plots, to include large tree survey plots, or to focus only on Stocked land and tall trees.
Users can also choose the criteria for post-stratification using the \code{strat} parameter.
}
\details{
This function calculates biomass using methodologies employed for national statistics (mean, variance, standard error, relative standard error):
\itemize{
\item Applies national carbon emission factors to calculate biomass at the individual tree level.
\item Estimates biomass per hectare at the cluster or subplot level, with options to include only basic survey trees or both basic and large tree survey trees.
\item Uses the Double Sampling for Post-stratification (DSS) method to derive annual statistics.
\item Applies the Weighted Moving Average (WMA) method to integrate annual statistics from the 20\% of plots surveyed each year into a single time point.
}
}
\note{
Biomass calculation involves dividing the data into groups based on \code{plotgrp} and then applying post-stratification to each group.
As a result, if the data for each group is not sufficiently large, the relative standard error (RSE) may be high.
It is important to check the RSE and other statistical measures in the biomass results.
}
\examples{

data("nfi_donghae")

# Basic usage
biomass <- biomass_nfi(nfi_donghae)

# Calculate biomass by administrative district
district_biomass <- biomass_nfi(nfi_donghae, plotgrp = "SGG")

# Calculate biomass for each plot
plot_biomass <- biomass_nfi(nfi_donghae, byplot = TRUE)

}
\references{
Son, Y., Kim, R., Lee, K., Pyo, J., Kim, S., Hwang, J., Lee, S., & Park, H. (2014). Carbon emission factors and biomass allometric equations by species in Korea. Korea Forest Research Institute.
Yim, J., Moon, G., Lee, M., Kang, J., Won, M., Ahn, E., & Jeon, J. (2021). 2020 Forest inventory of Korea. Korea Forest Research Institute.
}
