% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_kernel_matrix.R
\name{get_kernel_matrix}
\alias{get_kernel_matrix}
\title{Get the kernel matrix for a dataset}
\usage{
get_kernel_matrix(data, kern = "g", param1 = 1, param2 = 1)
}
\arguments{
\item{data}{data vector}

\item{kern}{the kernel to use, one of ('gaussian', 'poly', 'sigmoid', 'laplacian'), can use first
letter}

\item{param1}{first parameter to pass to kernel function.}

\item{param2}{second parameter to pass to kernel function.}
}
\value{
An n x n matrix for \code{data} given by the specified kernel. The value
in position (i, j) corresponds to the kernel function evaluated at \code{data[i, ]}
and \code{data[j, ]}.
}
\description{
Given a dataset, kernel function, and tuning parameter, will
return the n x n kernel matrix
}
