% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axials_standard.R
\name{axpermute_standard}
\alias{axpermute_standard}
\title{Takes (at least) two vectors of kinship dispersal distances from defined kinship categories, and returns a resulting calculation of the parent-offspring (intergenerational) kinship dispersal kernel with bootstrap-based confidence intervals.
Further tests}
\usage{
axpermute_standard(
  avect = NULL,
  bvect = NULL,
  acat = NULL,
  bcat = NULL,
  nreps = 1000,
  nsamp = "std",
  amix = FALSE,
  bmix = FALSE,
  amixcat = NULL,
  bmixcat = NULL,
  acomp = FALSE,
  bcomp = FALSE,
  acompvect = NULL,
  bcompvect = NULL,
  acompcat = NULL,
  bcompcat = NULL,
  output = "confs"
)
}
\arguments{
\item{avect}{vector a of kin dispersal distances for the less closely related kinship category OR object of class KinPairData.}

\item{bvect}{vector b of kin dispersal distances for the more closely related kinship category OR object of class KinPairData.}

\item{acat}{kinship category of kin dispersal vector avect. Must be one of "PO", "FS", "HS", "AV", "GG", "HAV", "GGG", "1C", "1C1", "2C", "GAV", "HGAV", "H1C", "H1C1", "H2C"}

\item{bcat}{kinship category of kin dispersal vector bvect. Must be one of "PO", "FS", "HS", "AV", "GG", "HAV", "GGG", "1C", "1C1", "2C", "GAV", "HGAV", "H1C", "H1C1", "H2C"}

\item{nreps}{number of permutations to run for confidence intervals (default 1000)}

\item{nsamp}{number of kin pairs to subsample for each permutation. Either "std" or an integer. If "std" will be computed as equal to the sample size. (default "std")}

\item{amix}{logical describing whether vector a is a mixture of two kinship categories. Used with amixcat. Default FALSE.}

\item{bmix}{logical describing whether vector b is a mixture of two kinship categories. Used with bmixcat. Default FALSE.}

\item{amixcat}{mixture kinship category of vector a. Must be set if amix == TRUE. Must be one of "PO", "FS", "HS", "AV", "GG", "HAV", "GGG", "1C", "1C1", "2C", "GAV", "HGAV", "H1C", "H1C1", "H2C"}

\item{bmixcat}{mixture kinship category of vector b. Must be set if bmix == TRUE. Must be one of "PO", "FS", "HS", "AV", "GG", "HAV", "GGG", "1C", "1C1", "2C", "GAV", "HGAV", "H1C", "H1C1", "H2C"}

\item{acomp}{logical denoting whether vector a should be composited with an additional kinship category vector. Used with acompvect and acompcat. Default FALSE.}

\item{bcomp}{logical denoting whether vector b should be composited with an additional kinship category vector. Used with bcompvect and bcompcat. Default FALSE.}

\item{acompvect}{vector acomp of kin dispersal distances for compositing with vector a OR object of class KinPairData. Must be set if acomp == TRUE.}

\item{bcompvect}{vector bcomp of kin dispersal distances for compositing with vector b OR object of class KinPairData. Must be set if bcomp == TRUE.}

\item{acompcat}{kinship category of kin dispersal vector acompvect. Must be set if acomp == TRUE.  Must be one of "PO", "FS", "HS", "AV", "GG", "HAV", "GGG", "1C", "1C1", "2C", "GAV", "HGAV", "H1C", "H1C1", "H2C"}

\item{bcompcat}{kinship category of kin dispersal vector bcompvect. Must be set if bcomp == TRUE. Must be one of "PO", "FS", "HS", "AV", "GG", "HAV", "GGG", "1C", "1C1", "2C", "GAV", "HGAV", "H1C", "H1C1", "H2C"}

\item{output}{string denoting what kind of output to return. If 'confs', a vector of 95\% confidence intervals. if 'vect', a vector of all permutated axial value results}
}
\value{
If output = 'confs' returns vector of 95\% confidence intervals (with mean).
If output = 'vect' returns vector of individual axial estimates from each permutation
}
\description{
Takes (at least) two vectors of kinship dispersal distances from defined kinship categories, and returns a resulting calculation of the parent-offspring (intergenerational) kinship dispersal kernel with bootstrap-based confidence intervals.
Further tests
}
\examples{
cous <- rexp(100, 1 / 100)
fullsibs <- rexp(50, 1 / 50)
axpermute_standard(cous, fullsibs, acat = "1C", bcat = "FS")
}
