% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairData.R
\docType{class}
\name{KinPairData-class}
\alias{KinPairData-class}
\alias{KinPairData}
\alias{show,KinPairData-method}
\alias{initialize,KinPairData-method}
\title{Formal class KinPairData}
\usage{
\S4method{show}{KinPairData}(object)

\S4method{initialize}{KinPairData}(
  .Object,
  data = NULL,
  kinship = NULL,
  lifestage = NULL,
  cycle = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class KinpairData}

\item{.Object}{the KinPairData object to be constructed}

\item{data}{data about kinship to be used to construct object (tibble, data.frame, or numeric vector of distances)}

\item{kinship}{character. Kinship category value for object. - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{lifestage}{character. Lifestage value for object. - one of 'immature', 'ovipositional' or 'unknown'}

\item{cycle}{non-negative integer or vector of two such integers - Represents
the number of complete breeding cycles each simulated individual has undergone before the sampling point, where the time between
birth and first reproduction is coded as '0', that between first and second reproduction '1', etc. (default 0). If the first individual
was sampled as a juvenile & the second as an adult of equivalent stage, the vector c(0, 1) would be used. In most situations, defualt will be appropriate}

\item{...}{additional argument to pass to downstream functions in future}

\item{KinPairData}{object of class KinPairData}
}
\value{
returns object of class \code{KinPairData}

No return value, called for side effects

Returns an object of class \code{KinPairData}
}
\description{
The class \code{KinPairData} is a formal (S4) class for storing kinship and lifespan dispersal
information concerning kin pairs. It is the base class on which the \code{KinPairSimulation} class is built.
The \code{KinPairData} class is used to store information about the spatial distribution of kin dyads for use
in calculating axial sigmas of intergenerational dispersal as initially implemented in Jasper et al. 2019
(\doi{https://doi.org/10.1111/1755-0998.13043}).
}
\details{
This class is essentially wrapped around the \code{tbl_df} class but with (a) expectations around certain columns
that must be present (\code{id1, id2, kinship}, & \code{distance} - three 'character' & one 'numeric' column), as
well as (b) additional attributes (\code{kinship}, \code{lifestage}, & \code{cycle}) characterizing the close-kin
dyads being stored.These attributes, as well as the embedded vector of distances, can be accessed with the methods
\code{\link{kinship}}, \code{\link{lifestage}}, \code{\link{breeding_cycle}} and \code{\link{distances}}.

Objects from this class are returned from the \code{\link{df_to_kinpair}} and \code{\link{csv_to_kinpair}} functions
(& related), and are directly constructed with the namesake \code{KinPairData()} function.
They can be passed to the \code{\link{sample_kindist}} function for filtering and subsampling, and to
axial functions (including \code{\link{axials_standard}} and \code{\link{axpermute_standard}}) for estimation of
axial dispersal.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: standard print method

\item \code{initialize}: initialize method
}}

\section{Slots}{

\describe{
\item{\code{kinship}}{character - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{\code{lifestage}}{character - lifestage at sampling - either 'immature', 'ovipositional' or a stage
corresponding to a \code{DispersalModel} custom stage}

\item{\code{cycle}}{non-negative integer or vector of two such integers - Represents
the number of complete breeding cycles each  individual has undergone before the sampling point, where the time between
birth and first reproduction is coded as '0', that between first and second reproduction '1', etc. (default 0). If the first individual
was sampled as a juvenile & the second as an adult of equivalent stage, the vector c(0, 1) would be used. In most situations, the default will be appropriate}

\item{\code{tab}}{tbl_df. - tibble of dispersal values}
}}

\seealso{
Other kdclasses: 
\code{\link{DispersalModel-class}},
\code{\link{KinPairSimulation-class}}
}
\concept{kdclasses}
