% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_kim.R
\name{theme_kim}
\alias{theme_kim}
\title{Theme Kim}
\usage{
theme_kim(
  legend_position = "none",
  legend_spacing_y = 1,
  legend_key_size = 3,
  base_size = 20,
  axis_tick_font_size = 20,
  axis_title_font_size = 24,
  y_axis_title_vjust = 0.85,
  axis_title_margin_size = 24,
  cap_axis_lines = FALSE
)
}
\arguments{
\item{legend_position}{position of the legend (default = "none")}

\item{legend_spacing_y}{vertical spacing of the legend keys in
the unit of "cm" (default = 1)}

\item{legend_key_size}{size of the legend keys in the unit of "lines"
(default = 3)}

\item{base_size}{base font size}

\item{axis_tick_font_size}{font size for axis tick marks}

\item{axis_title_font_size}{font size for axis title}

\item{y_axis_title_vjust}{position of the y axis title (default = 0.85).
If default is used, \code{y_axis_title_vjust = 0.85}, the y axis title
will be positioned at 85\% of the way up from the bottom of the plot.}

\item{axis_title_margin_size}{size of the margin between axis title
and the axis line}

\item{cap_axis_lines}{logical. Should the axis lines be capped at the
outer tick marks? (default = FALSE)}
}
\value{
a ggplot object; there will be no meaningful output from
this function. Instead, this function should be used with another
ggplot object, e.g., \code{
ggplot(mtcars , aes(x = disp, y = mpg)) + theme_kim()}
}
\description{
A custom ggplot theme
}
\details{
If a axis lines are to be capped at the ends, the following package(s)
must be installed prior to running the function:
Package 'lemon' v0.4.4 (or possibly a higher version) by
Edwards et al. (2020),
\url{https://cran.r-project.org/package=lemon}
}
\examples{
\donttest{
prep(ggplot2)
ggplot2::ggplot(mtcars, aes(x = cyl, y = mpg)) +
geom_point() + theme_kim()
}
}
