% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pause.R
\name{pauseKey}
\alias{pauseKey}
\alias{unpauseKey}
\title{Pause or Unpause Keys}
\usage{
pauseKey(session = shiny::getDefaultReactiveDomain())

unpauseKey(session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}
}
\description{
These functions allow to pause and unpause keyboard watching
}
\examples{
if (interactive()){
library(shiny)
ui <- fluidPage(
  useKeys(),
  keysInput("keys", letters),
  actionButton("pause", "Pause"),
  actionButton("unpause", "Unpause")
)

server <- function(input, output, session) {
  observeEvent(input$keys, {
    print(input$keys)
  })
  observeEvent(input$pause, {
    pauseKey()
  })
  observeEvent(input$unpause, {
    unpauseKey()
  })

}

shinyApp(ui, server)
}
}
