% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_keras_model.R
\name{plot_keras_model}
\alias{plot_keras_model}
\title{Plot Keras model}
\usage{
plot_keras_model(
  model,
  to_file = "model.png",
  show_shapes = FALSE,
  show_layer_names = TRUE,
  rankdir = "TB",
  expand_nested = FALSE,
  dpi = 96
)
}
\arguments{
\item{model}{A Keras model instance}

\item{to_file}{File name of the plot image.}

\item{show_shapes}{whether to display shape information.}

\item{show_layer_names}{whether to display layer names.}

\item{rankdir}{`rankdir` argument passed to PyDot, a string specifying the format of the plot: 
'TB' creates a vertical plot; 'LR' creates a horizontal plot.}

\item{expand_nested}{Whether to expand nested models into clusters.}

\item{dpi}{Dots per inch.}
}
\value{
saves a png image on the system and builds a plot in R
}
\description{
Converts a Keras model to dot format and save to a file.
}
