% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{load_model}
\alias{load_model}
\title{Loads a model saved via \code{save_model()}.}
\usage{
load_model(model, custom_objects = NULL, compile = TRUE, safe_mode = TRUE)
}
\arguments{
\item{model}{string, path to the saved model file,
or a raw vector, as returned by \code{save_model(filepath = NULL)}}

\item{custom_objects}{Optional named list mapping names
to custom classes or functions to be
considered during deserialization.}

\item{compile}{Boolean, whether to compile the model after loading.}

\item{safe_mode}{Boolean, whether to disallow unsafe \code{lambda} deserialization.
When \code{safe_mode=FALSE}, loading an object has the potential to
trigger arbitrary code execution. This argument is only
applicable to the Keras v3 model format. Defaults to \code{TRUE}.}
}
\value{
A Keras model instance. If the original model was compiled,
and the argument \code{compile = TRUE} is set, then the returned model
will be compiled. Otherwise, the model will be left uncompiled.
}
\description{
Loads a model saved via \code{save_model()}.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{model <- keras_model_sequential(input_shape = c(3)) |>
  layer_dense(5) |>
  layer_activation_softmax()

model |> save_model("model.keras")
loaded_model <- load_model("model.keras")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- random_uniform(c(10, 3))
stopifnot(all.equal(
  model |> predict(x),
  loaded_model |> predict(x)
))
}\if{html}{\out{</div>}}

Note that the model variables may have different name values
(\code{var$name} property, e.g. \code{"dense_1/kernel:0"}) after being reloaded.
It is recommended that you use layer attributes to
access specific variables, e.g. \code{model |> get_layer("dense_1") |> _$kernel}.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_saving_apis/model_saving_and_loading#loadmodel-function}
}

Other saving and loading functions: \cr
\code{\link{export_savedmodel.keras.src.models.model.Model}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{load_model_weights}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{save_model}()} \cr
\code{\link{save_model_config}()} \cr
\code{\link{save_model_weights}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{saving and loading functions}
