% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-methods.R
\name{reset_state}
\alias{reset_state}
\title{Reset the state for a model, layer or metric.}
\usage{
reset_state(object)
}
\arguments{
\item{object}{Model, Layer, or Metric instance

Not all Layers have resettable state (E.g., \code{adapt()}-able preprocessing
layers and rnn layers have resettable state, but a \code{layer_dense()} does not).
Calling this on a Layer instance without any resettable-state will error.}
}
\value{
\code{object}, invisibly.
}
\description{
Reset the state for a model, layer or metric.
}
\seealso{
Other layer methods: \cr
\code{\link{count_params}()} \cr
\code{\link{get_config}()} \cr
\code{\link{get_weights}()} \cr
}
\concept{layer methods}
