% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{dataset_imdb}
\alias{dataset_imdb}
\alias{dataset_imdb_word_index}
\title{IMDB Movie reviews sentiment classification}
\usage{
dataset_imdb(
  path = "imdb.npz",
  num_words = NULL,
  skip_top = 0L,
  maxlen = NULL,
  seed = 113L,
  start_char = 1L,
  oov_char = 2L,
  index_from = 3L
)

dataset_imdb_word_index(path = "imdb_word_index.json")
}
\arguments{
\item{path}{Where to cache the data (relative to \verb{~/.keras/dataset}).}

\item{num_words}{Max number of words to include. Words are ranked by how
often they occur (in the training set) and only the most frequent words are
kept}

\item{skip_top}{Skip the top N most frequently occuring words (which may not
be informative).}

\item{maxlen}{sequences longer than this will be filtered out.}

\item{seed}{random seed for sample shuffling.}

\item{start_char}{The start of a sequence will be marked with this character.
Set to 1 because 0 is usually the padding character.}

\item{oov_char}{Words that were cut out because of the \code{num_words} or
\code{skip_top} limit will be replaced with this character.}

\item{index_from}{Index actual words with this index and higher.}
}
\value{
Lists of training and test data: \verb{train$x, train$y, test$x, test$y}.

The \code{x} data includes integer sequences. If the \code{num_words} argument was
specific, the maximum possible index value is \code{num_words-1}. If the
\code{maxlen} argument was specified, the largest possible sequence length is
\code{maxlen}.

The \code{y} data includes a set of integer labels (0 or 1).

The \code{dataset_imdb_word_index()} function returns a list where the
names are words and the values are integer.
}
\description{
Dataset of 25,000 movies reviews from IMDB, labeled by sentiment
(positive/negative). Reviews have been preprocessed, and each review is
encoded as a sequence of word indexes (integers). For convenience, words are
indexed by overall frequency in the dataset, so that for instance the integer
"3" encodes the 3rd most frequent word in the data. This allows for quick
filtering operations such as: "only consider the top 10,000 most common
words, but eliminate the top 20 most common words".
}
\details{
As a convention, "0" does not stand for a specific word, but instead is used
to encode any unknown word.
}
\seealso{
Other datasets: \cr
\code{\link{dataset_boston_housing}()} \cr
\code{\link{dataset_cifar10}()} \cr
\code{\link{dataset_cifar100}()} \cr
\code{\link{dataset_fashion_mnist}()} \cr
\code{\link{dataset_mnist}()} \cr
\code{\link{dataset_reuters}()} \cr
}
\concept{datasets}
