% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clear_session}
\alias{clear_session}
\title{Resets all state generated by Keras.}
\usage{
clear_session()
}
\value{
\code{NULL}, invisibly, called for side effects.
}
\description{
Keras manages a global state, which it uses to implement the Functional
model-building API and to uniquify autogenerated layer names.

If you are creating many models in a loop, this global state will consume
an increasing amount of memory over time, and you may want to clear it.
Calling \code{clear_session()} releases the global state: this helps avoid
clutter from old models and layers, especially when memory is limited.

Example 1: calling \code{clear_session()} when creating models in a loop

\if{html}{\out{<div class="sourceCode r">}}\preformatted{for (i in 1:100) \{
  # Without `clear_session()`, each iteration of this loop will
  # slightly increase the size of the global state managed by Keras
  model <- keras_model_sequential()
  for (j in 1:10) \{
    model <- model |> layer_dense(units = 10)
  \}
\}

for (i in 1:100) \{
  # With `clear_session()` called at the beginning,
  # Keras starts with a blank state at each iteration
  # and memory consumption is constant over time.
  clear_session()
  model <- keras_model_sequential()
  for (j in 1:10) \{
    model <- model |> layer_dense(units = 10)
  \}
\}
}\if{html}{\out{</div>}}

Example 2: resetting the layer name generation counter

\if{html}{\out{<div class="sourceCode r">}}\preformatted{layers <- lapply(1:10, \\(i) layer_dense(units = 10))

new_layer <- layer_dense(units = 10)
print(new_layer$name)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "dense_10"

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{clear_session()
new_layer <- layer_dense(units = 10)
print(new_layer$name)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "dense"

}\if{html}{\out{</div>}}
}
\seealso{
\itemize{
\item \url{https://keras.io/api/utils/config_utils#clearsession-function}
}

Other backend: \cr
\code{\link{config_backend}()} \cr
\code{\link{config_epsilon}()} \cr
\code{\link{config_floatx}()} \cr
\code{\link{config_image_data_format}()} \cr
\code{\link{config_set_epsilon}()} \cr
\code{\link{config_set_floatx}()} \cr
\code{\link{config_set_image_data_format}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pack_x_y_sample_weight}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{unpack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{backend}
\concept{utils}
