% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_resnet}
\alias{application_resnet}
\alias{application_resnet50}
\alias{application_resnet101}
\alias{application_resnet152}
\alias{application_resnet50_v2}
\alias{application_resnet101_v2}
\alias{application_resnet152_v2}
\alias{resnet_preprocess_input}
\alias{resnet_v2_preprocess_input}
\title{Instantiates the ResNet architecture}
\usage{
application_resnet50(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000,
  ...
)

application_resnet101(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000,
  ...
)

application_resnet152(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000,
  ...
)

application_resnet50_v2(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000,
  classifier_activation = "softmax",
  ...
)

application_resnet101_v2(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000,
  classifier_activation = "softmax",
  ...
)

application_resnet152_v2(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000,
  classifier_activation = "softmax",
  ...
)

resnet_preprocess_input(x)

resnet_v2_preprocess_input(x)
}
\arguments{
\item{include_top}{Whether to include the fully-connected
layer at the top of the network. Defaults to \code{TRUE}.}

\item{weights}{One of \code{NULL} (random initialization),
\code{'imagenet'} (pre-training on ImageNet),
or the path to the weights file to be loaded. Defaults to \code{'imagenet'}.}

\item{input_tensor}{Optional Keras tensor
(i.e. output of \code{layer_input()})
to use as image input for the model.}

\item{input_shape}{optional shape list, only to be specified
if \code{include_top} is FALSE (otherwise the input shape
has to be \code{c(224, 224, 3)} (with \code{'channels_last'} data format)
or \code{c(3, 224, 224)} (with \code{'channels_first'} data format).
It should have exactly 3 inputs channels,
and width and height should be no smaller than 32.
E.g. \code{c(200, 200, 3)} would be one valid value.}

\item{pooling}{Optional pooling mode for feature extraction
when \code{include_top} is \code{FALSE}. Defaults to \code{NULL}.
\itemize{
\item \code{NULL} means that the output of the model will be
the 4D tensor output of the
last convolutional layer.
\item \code{'avg'} means that global average pooling
will be applied to the output of the
last convolutional layer, and thus
the output of the model will be a 2D tensor.
\item \code{'max'} means that global max pooling will
be applied.
}}

\item{classes}{Optional number of classes to classify images into, only to be
specified if \code{include_top} is TRUE, and if no \code{weights} argument is
specified. Defaults to 1000 (number of ImageNet classes).}

\item{...}{For backwards and forwards compatibility}

\item{classifier_activation}{A string or callable. The activation function to
use on the "top" layer. Ignored unless \code{include_top = TRUE}. Set
\code{classifier_activation = NULL} to return the logits of the "top" layer.
Defaults to \code{'softmax'}. When loading pretrained weights,
\code{classifier_activation} can only be \code{NULL} or \code{"softmax"}.}

\item{x}{\code{preprocess_input()} takes an array or floating point tensor, 3D or
4D with 3 color channels, with values in the range \verb{[0, 255]}.}
}
\description{
Instantiates the ResNet architecture
}
\details{
Reference:
\itemize{
\item \href{https://arxiv.org/abs/1512.03385}{Deep Residual Learning for Image Recognition} (CVPR 2015)
}

For image classification use cases, see
\href{https://keras.io/api/applications/#usage-examples-for-image-classification-models}{this page for detailed examples}.

For transfer learning use cases, make sure to read the
\href{https://keras.io/guides/transfer_learning/}{guide to transfer learning & fine-tuning}.

Note: each Keras Application expects a specific kind of input preprocessing.
For ResNet, call \code{tf.keras.applications.resnet.preprocess_input} on your
inputs before passing them to the model.
\code{resnet.preprocess_input} will convert the input images from RGB to BGR,
then will zero-center each color channel with respect to the ImageNet dataset,
without scaling.
}
\examples{
\dontrun{
library(keras)

# instantiate the model
model <- application_resnet50(weights = 'imagenet')

# load the image
img_path <- "elephant.jpg"
img <- image_load(img_path, target_size = c(224,224))
x <- image_to_array(img)

# ensure we have a 4d tensor with single element in the batch dimension,
# the preprocess the input for prediction using resnet50
x <- array_reshape(x, c(1, dim(x)))
x <- imagenet_preprocess_input(x)

# make predictions then decode and print them
preds <- model \%>\% predict(x)
imagenet_decode_predictions(preds, top = 3)[[1]]
}
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/applications/resnet50/ResNet50}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/applications/resnet/ResNet101}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/applications/resnet/ResNet152}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/applications/resnet_v2/ResNet50V2}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/applications/resnet_v2/ResNet101V2}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/applications/resnet_v2/ResNet152V2}
\item \url{https://keras.io/api/applications/}
}
}
